/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import xeij.M68kException;
import xeij.QFP;
import xeij.Settings;
import xeij.XEiJ;

public class FEFunction {
    public static final boolean FPK_DEBUG_TRACE = false;
    public static final int FPK_CLOCK = 80;
    public static final boolean FPK_FPCP_NAN = true;
    public static boolean fpkOn;
    public static boolean fpkRejectFloatOn;
    public static final int[] fpkRndTable;
    public static int fpkRndPointer;
    public static final short[] fpkRandTable;
    public static int fpkRandPointer;
    public static final double[] FPK_TEN_P16QR;
    public static final double[] FPK_TEN_M16QR;

    public static void fpkInit() {
        fpkOn = Settings.sgsGetOnOff("fefunc");
        fpkRejectFloatOn = Settings.sgsGetOnOff("rejectfloat");
    }

    public static void fpkRndInit(int n) {
        for (int i = 0; i < 55; ++i) {
            n = (char)n * 15625 + 1;
            FEFunction.fpkRndTable[i] = n << 16 | (char)n;
        }
        fpkRndPointer = 54;
        FEFunction.fpkRndShuffle();
        FEFunction.fpkRndShuffle();
        FEFunction.fpkRndShuffle();
    }

    public static void fpkRndShuffle() {
        int n;
        for (n = 0; n < 24; ++n) {
            int n2 = n;
            fpkRndTable[n2] = fpkRndTable[n2] - fpkRndTable[n + 31];
        }
        for (n = 24; n < 55; ++n) {
            int n3 = n;
            fpkRndTable[n3] = fpkRndTable[n3] - fpkRndTable[n - 24];
        }
    }

    public static int fpkRndLong() {
        int n = fpkRndPointer;
        if (n < 0) {
            FEFunction.fpkRndInit(111);
            n = fpkRndPointer;
        }
        if (n == 54) {
            FEFunction.fpkRndShuffle();
            n = 0;
        } else {
            ++n;
        }
        fpkRndPointer = n;
        return fpkRndTable[n];
    }

    public static void fpkRandInit(int n) {
        for (int i = 0; i < 55; ++i) {
            n = (char)n * 15625 + 1;
            FEFunction.fpkRandTable[i] = (short)n;
        }
        fpkRandPointer = 54;
        FEFunction.fpkRandShuffle();
    }

    public static void fpkRandShuffle() {
        int n;
        for (n = 0; n < 24; ++n) {
            int n2 = n;
            fpkRandTable[n2] = (short)(fpkRandTable[n2] - fpkRandTable[n + 31]);
        }
        for (n = 24; n < 55; ++n) {
            int n3 = n;
            fpkRandTable[n3] = (short)(fpkRandTable[n3] - fpkRandTable[n - 24]);
        }
    }

    public static short fpkRandShort() {
        int n = fpkRandPointer;
        if (n < 0) {
            FEFunction.fpkRandInit(51);
            n = fpkRandPointer;
        }
        if (n == 54) {
            FEFunction.fpkRandShuffle();
            n = 0;
        } else {
            ++n;
        }
        fpkRandPointer = n;
        return fpkRandTable[n];
    }

    public static void fpkLMUL() {
        long l = XEiJ.regRn[0];
        long l2 = XEiJ.regRn[1];
        long l3 = l * l2;
        int n = (int)l3;
        if ((long)n != l3) {
            XEiJ.regRn[0] = n;
            XEiJ.regCCR = 3;
        } else {
            XEiJ.regRn[0] = n;
            XEiJ.regCCR = 0;
        }
    }

    public static void fpkLDIV() {
        long l = XEiJ.regRn[0];
        long l2 = XEiJ.regRn[1];
        if (l2 == 0L) {
            XEiJ.regCCR = 5;
        } else {
            long l3 = l / l2;
            int n = (int)l3;
            if ((long)n != l3) {
                XEiJ.regRn[0] = Integer.MAX_VALUE;
                XEiJ.regCCR = 3;
            } else {
                XEiJ.regRn[0] = n;
                XEiJ.regCCR = 0;
            }
        }
    }

    public static void fpkLMOD() {
        long l = XEiJ.regRn[0];
        long l2 = XEiJ.regRn[1];
        if (l2 == 0L) {
            XEiJ.regCCR = 5;
        } else {
            int n;
            long l3 = l % l2;
            XEiJ.regRn[0] = n = (int)l3;
            XEiJ.regCCR = 0;
        }
    }

    public static void fpkUMUL() {
        long l = 0xFFFFFFFFL & (long)XEiJ.regRn[0];
        long l2 = 0xFFFFFFFFL & (long)XEiJ.regRn[1];
        long l3 = l * l2;
        int n = (int)l3;
        if ((0xFFFFFFFFL & (long)n) != l3) {
            XEiJ.regRn[0] = n;
            XEiJ.regCCR = 3;
        } else {
            XEiJ.regRn[0] = n;
            XEiJ.regCCR = 0;
        }
    }

    public static void fpkUDIV() {
        long l = 0xFFFFFFFFL & (long)XEiJ.regRn[0];
        long l2 = 0xFFFFFFFFL & (long)XEiJ.regRn[1];
        if (l2 == 0L) {
            XEiJ.regCCR = 5;
        } else {
            int n;
            long l3 = l / l2;
            XEiJ.regRn[0] = n = (int)l3;
            XEiJ.regCCR = 0;
        }
    }

    public static void fpkUMOD() {
        long l = 0xFFFFFFFFL & (long)XEiJ.regRn[0];
        long l2 = 0xFFFFFFFFL & (long)XEiJ.regRn[1];
        if (l2 == 0L) {
            XEiJ.regCCR = 5;
        } else {
            int n;
            long l3 = l % l2;
            XEiJ.regRn[0] = n = (int)l3;
            XEiJ.regCCR = 0;
        }
    }

    public static void fpkIMUL() {
        long l = 0xFFFFFFFFL & (long)XEiJ.regRn[0];
        long l2 = 0xFFFFFFFFL & (long)XEiJ.regRn[1];
        long l3 = l * l2;
        XEiJ.regRn[0] = (int)(l3 >>> 32);
        XEiJ.regRn[1] = (int)l3;
    }

    public static void fpkIDIV() {
        long l = 0xFFFFFFFFL & (long)XEiJ.regRn[0];
        long l2 = 0xFFFFFFFFL & (long)XEiJ.regRn[1];
        if (l2 == 0L) {
            XEiJ.regCCR = 1;
        } else {
            long l3 = l / l2;
            XEiJ.regRn[0] = (int)l3;
            XEiJ.regRn[1] = (int)(l - l2 * l3);
            XEiJ.regCCR = 0;
        }
    }

    public static void fpkRANDOMIZE() {
        FEFunction.fpkRndInit(XEiJ.regRn[0]);
        XEiJ.regRn[0] = 0;
    }

    public static void fpkSRAND() {
        FEFunction.fpkRandInit(XEiJ.regRn[0]);
        XEiJ.regRn[0] = 0;
    }

    public static void fpkRAND() {
        XEiJ.regRn[0] = FEFunction.fpkRandShort() & Short.MAX_VALUE;
    }

    public static void fpkLTOD() {
        long l = Double.doubleToLongBits(XEiJ.regRn[0]);
        XEiJ.regRn[0] = (int)(l >>> 32);
        XEiJ.regRn[1] = (int)l;
    }

    public static void fpkDTOL() {
        double d = Double.longBitsToDouble((long)XEiJ.regRn[0] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1]);
        XEiJ.regRn[0] = (int)d;
        XEiJ.regCCR = -2.147483649E9 < d && d < 2.147483648E9 ? 0 : 1;
    }

    public static void fpkLTOF() {
        XEiJ.regRn[0] = Float.floatToIntBits(XEiJ.regRn[0]);
    }

    public static void fpkFTOL() {
        float f = Float.intBitsToFloat(XEiJ.regRn[0]);
        XEiJ.regRn[0] = (int)f;
        XEiJ.regCCR = -2.1474836E9f < f && f < 2.1474836E9f ? 0 : 1;
    }

    public static void fpkFTOD() {
        long l = Double.doubleToLongBits(Float.intBitsToFloat(XEiJ.regRn[0]));
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        XEiJ.regRn[0] = (int)(l >>> 32);
        XEiJ.regRn[1] = (int)l;
    }

    public static void fpkDTOF() {
        double d = Double.longBitsToDouble((long)XEiJ.regRn[0] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1]);
        int n = Float.floatToIntBits((float)d);
        if (n == 2143289344) {
            n = Integer.MAX_VALUE;
        }
        XEiJ.regRn[0] = n;
        XEiJ.regCCR = Double.isNaN(d) || Double.isInfinite(d) || Math.abs(d) < 3.4028234663852886E38 + 0.5 * (double)Math.ulp(Float.MAX_VALUE) ? 0 : 1;
    }

    public static void fpkDTST() {
        long l = (long)XEiJ.regRn[0] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1];
        XEiJ.regCCR = l << 1 == 0L ? 4 : (0L <= l ? 0 : 8);
    }

    public static void fpkDCMP() {
        double d;
        double d2 = Double.longBitsToDouble((long)XEiJ.regRn[0] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1]);
        XEiJ.regCCR = d2 < (d = Double.longBitsToDouble((long)XEiJ.regRn[2] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[3])) ? 9 : (d2 == d ? 4 : 0);
    }

    public static void fpkDNEG() {
        long l = Double.doubleToLongBits(-Double.longBitsToDouble((long)XEiJ.regRn[0] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1]));
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        XEiJ.regRn[0] = (int)(l >>> 32);
        XEiJ.regRn[1] = (int)l;
    }

    public static void fpkDADD() {
        double d;
        double d2 = Double.longBitsToDouble((long)XEiJ.regRn[0] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1]);
        double d3 = d2 + (d = Double.longBitsToDouble((long)XEiJ.regRn[2] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[3]));
        long l = Double.doubleToLongBits(d3);
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        XEiJ.regRn[0] = (int)(l >>> 32);
        XEiJ.regRn[1] = (int)l;
        XEiJ.regCCR = Double.isNaN(d2) || Double.isNaN(d) ? 0 : (Double.isNaN(d3) ? 1 : (Double.isInfinite(d2) || Double.isInfinite(d) ? 0 : (Double.isInfinite(d3) ? 3 : 0)));
    }

    public static void fpkDSUB() {
        double d;
        double d2 = Double.longBitsToDouble((long)XEiJ.regRn[0] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1]);
        double d3 = d2 - (d = Double.longBitsToDouble((long)XEiJ.regRn[2] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[3]));
        long l = Double.doubleToLongBits(d3);
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        XEiJ.regRn[0] = (int)(l >>> 32);
        XEiJ.regRn[1] = (int)l;
        XEiJ.regCCR = Double.isNaN(d2) || Double.isNaN(d) ? 0 : (Double.isNaN(d3) ? 1 : (Double.isInfinite(d2) || Double.isInfinite(d) ? 0 : (Double.isInfinite(d3) ? 3 : 0)));
    }

    public static void fpkDMUL() {
        double d;
        double d2 = Double.longBitsToDouble((long)XEiJ.regRn[0] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1]);
        double d3 = d2 * (d = Double.longBitsToDouble((long)XEiJ.regRn[2] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[3]));
        long l = Double.doubleToLongBits(d3);
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        XEiJ.regRn[0] = (int)(l >>> 32);
        XEiJ.regRn[1] = (int)l;
        XEiJ.regCCR = Double.isNaN(d2) || Double.isNaN(d) ? 0 : (Double.isNaN(d3) ? 1 : (Double.isInfinite(d2) || Double.isInfinite(d) ? 0 : (Double.isInfinite(d3) ? 3 : 0)));
    }

    public static void fpkDDIV() {
        double d;
        double d2 = Double.longBitsToDouble((long)XEiJ.regRn[0] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1]);
        double d3 = d2 / (d = Double.longBitsToDouble((long)XEiJ.regRn[2] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[3]));
        long l = Double.doubleToLongBits(d3);
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        XEiJ.regRn[0] = (int)(l >>> 32);
        XEiJ.regRn[1] = (int)l;
        XEiJ.regCCR = Double.isNaN(d2) || Double.isNaN(d) ? 0 : (Double.isNaN(d3) ? 1 : (Double.isInfinite(d2) || Double.isInfinite(d) ? 0 : (d == 0.0 ? 5 : (Double.isInfinite(d3) ? 3 : 0))));
    }

    public static void fpkDMOD() {
        double d;
        double d2 = Double.longBitsToDouble((long)XEiJ.regRn[0] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1]);
        double d3 = d2 % (d = Double.longBitsToDouble((long)XEiJ.regRn[2] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[3]));
        long l = Double.doubleToLongBits(d3);
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        XEiJ.regRn[0] = (int)(l >>> 32);
        XEiJ.regRn[1] = (int)l;
        XEiJ.regCCR = Double.isNaN(d2) || Double.isNaN(d) ? 0 : (d == 0.0 ? 5 : (Double.isNaN(d3) ? 1 : (Double.isInfinite(d2) || Double.isInfinite(d) ? 0 : (Double.isInfinite(d3) ? 3 : 0))));
    }

    public static void fpkDABS() {
        long l = Double.doubleToLongBits(Math.abs(Double.longBitsToDouble((long)XEiJ.regRn[0] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1])));
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        XEiJ.regRn[0] = (int)(l >>> 32);
        XEiJ.regRn[1] = (int)l;
    }

    public static void fpkDCEIL() {
        long l = Double.doubleToLongBits(Math.ceil(Double.longBitsToDouble((long)XEiJ.regRn[0] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1])));
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        XEiJ.regRn[0] = (int)(l >>> 32);
        XEiJ.regRn[1] = (int)l;
    }

    public static void fpkDFIX() {
        double d = Double.longBitsToDouble((long)XEiJ.regRn[0] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1]);
        long l = Double.doubleToLongBits(0.0 <= d ? Math.floor(d) : Math.ceil(d));
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        XEiJ.regRn[0] = (int)(l >>> 32);
        XEiJ.regRn[1] = (int)l;
    }

    public static void fpkDFLOOR() {
        long l = Double.doubleToLongBits(Math.floor(Double.longBitsToDouble((long)XEiJ.regRn[0] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1])));
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        XEiJ.regRn[0] = (int)(l >>> 32);
        XEiJ.regRn[1] = (int)l;
    }

    public static void fpkDFRAC() {
        long l = (long)XEiJ.regRn[0] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1];
        double d = Double.longBitsToDouble(l);
        long l2 = Double.isNaN(d) ? Double.doubleToLongBits(Double.NaN) : (Double.isInfinite(d) ? l & Long.MIN_VALUE : (l = Double.doubleToLongBits(0L <= l ? d - Math.floor(d) : -(-d - Math.floor(-d)))));
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        XEiJ.regRn[0] = (int)(l >>> 32);
        XEiJ.regRn[1] = (int)l;
    }

    public static void fpkDSGN() {
        long l = Double.doubleToLongBits(Math.signum(Double.longBitsToDouble((long)XEiJ.regRn[0] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1])));
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        XEiJ.regRn[0] = (int)(l >>> 32);
        XEiJ.regRn[1] = (int)l;
    }

    public static void fpkSIN() {
        double d = Double.longBitsToDouble((long)XEiJ.regRn[0] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1]);
        double d2 = Math.sin(d);
        long l = Double.doubleToLongBits(d2);
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        XEiJ.regRn[0] = (int)(l >>> 32);
        XEiJ.regRn[1] = (int)l;
        XEiJ.regCCR = !Double.isNaN(d) && Double.isNaN(d2) ? 1 : 0;
    }

    public static void fpkCOS() {
        double d = Double.longBitsToDouble((long)XEiJ.regRn[0] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1]);
        double d2 = Math.cos(d);
        long l = Double.doubleToLongBits(d2);
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        XEiJ.regRn[0] = (int)(l >>> 32);
        XEiJ.regRn[1] = (int)l;
        XEiJ.regCCR = !Double.isNaN(d) && Double.isNaN(d2) ? 1 : 0;
    }

    public static void fpkTAN() {
        double d = Double.longBitsToDouble((long)XEiJ.regRn[0] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1]);
        double d2 = Math.tan(d);
        long l = Double.doubleToLongBits(d2);
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        XEiJ.regRn[0] = (int)(l >>> 32);
        XEiJ.regRn[1] = (int)l;
        XEiJ.regCCR = !Double.isNaN(d) && Double.isNaN(d2) ? 1 : 0;
    }

    public static void fpkATAN() {
        long l = Double.doubleToLongBits(Math.atan(Double.longBitsToDouble((long)XEiJ.regRn[0] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1])));
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        XEiJ.regRn[0] = (int)(l >>> 32);
        XEiJ.regRn[1] = (int)l;
    }

    public static void fpkLOG() {
        double d = Double.longBitsToDouble((long)XEiJ.regRn[0] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1]);
        double d2 = Math.log(d);
        long l = Double.doubleToLongBits(d2);
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        XEiJ.regRn[0] = (int)(l >>> 32);
        XEiJ.regRn[1] = (int)l;
        XEiJ.regCCR = Double.isNaN(d) ? 0 : (Double.isNaN(d2) ? 1 : (Double.isInfinite(d) ? 0 : (Double.isInfinite(d2) ? 5 : 0)));
    }

    public static void fpkEXP() {
        int n;
        int n2 = XEiJ.regRn[0];
        long l = Double.doubleToLongBits(Math.exp(Double.longBitsToDouble((long)n2 << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1])));
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        XEiJ.regRn[0] = n = (int)(l >>> 32);
        XEiJ.regRn[1] = (int)l;
        XEiJ.regCCR = (n & 0x7FF00000) == 0x7FF00000 && (n2 & 0x7FF00000) != 0x7FF00000 ? 1 : 0;
    }

    public static void fpkSQR() {
        double d = Double.longBitsToDouble((long)XEiJ.regRn[0] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1]);
        long l = Double.doubleToLongBits(Math.sqrt(d));
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        XEiJ.regRn[0] = (int)(l >>> 32);
        XEiJ.regRn[1] = (int)l;
        XEiJ.regCCR = d < 0.0 ? 1 : 0;
    }

    public static void fpkPI() {
        XEiJ.regRn[0] = 1074340347;
        XEiJ.regRn[1] = 1413754136;
    }

    public static void fpkNPI() {
        int n;
        int n2 = XEiJ.regRn[0];
        long l = Double.doubleToLongBits(new QFP(Double.longBitsToDouble((long)n2 << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1])).mul(QFP.QFP_PI).getd());
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        XEiJ.regRn[0] = n = (int)(l >>> 32);
        XEiJ.regRn[1] = (int)l;
        XEiJ.regCCR = (n & 0x7FF00000) == 0x7FF00000 && (n2 & 0x7FF00000) != 0x7FF00000 ? 1 : 0;
    }

    public static void fpkPOWER() {
        double d;
        double d2 = Double.longBitsToDouble((long)XEiJ.regRn[0] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1]);
        double d3 = Math.pow(d2, d = Double.longBitsToDouble((long)XEiJ.regRn[2] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[3]));
        long l = Double.doubleToLongBits(d3);
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        XEiJ.regRn[0] = (int)(l >>> 32);
        XEiJ.regRn[1] = (int)l;
        XEiJ.regCCR = Double.isNaN(d2) || Double.isNaN(d) ? 0 : (Double.isNaN(d3) ? 1 : (Double.isInfinite(d2) || Double.isInfinite(d) ? 0 : (Double.isInfinite(d3) ? 3 : 0)));
    }

    public static void fpkRND() {
        long l = 0xFFFFFFFFL & (long)FEFunction.fpkRndLong();
        int n = Long.numberOfLeadingZeros(l |= (0x1FFFFFL & (long)FEFunction.fpkRndLong()) << 32) - 11;
        l = (long)(1022 - n) << 52 | 0xFFFFFFFFFFFFFL & l << n;
        XEiJ.regRn[0] = (int)(l >>> 32);
        XEiJ.regRn[1] = (int)l;
    }

    public static void fpkSINH() {
        double d = Double.longBitsToDouble((long)XEiJ.regRn[0] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1]);
        double d2 = Math.sinh(d);
        long l = Double.doubleToLongBits(d2);
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        XEiJ.regRn[0] = (int)(l >>> 32);
        XEiJ.regRn[1] = (int)l;
        XEiJ.regCCR = Double.isNaN(d) ? 0 : (Double.isNaN(d2) ? 1 : (Double.isInfinite(d) ? 0 : (Double.isInfinite(d2) ? 3 : 0)));
    }

    public static void fpkCOSH() {
        double d = Double.longBitsToDouble((long)XEiJ.regRn[0] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1]);
        double d2 = Math.cosh(d);
        long l = Double.doubleToLongBits(d2);
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        XEiJ.regRn[0] = (int)(l >>> 32);
        XEiJ.regRn[1] = (int)l;
        XEiJ.regCCR = Double.isNaN(d) ? 0 : (Double.isNaN(d2) ? 1 : (Double.isInfinite(d) ? 0 : (Double.isInfinite(d2) ? 3 : 0)));
    }

    public static void fpkTANH() {
        long l = Double.doubleToLongBits(Math.tanh(Double.longBitsToDouble((long)XEiJ.regRn[0] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1])));
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        XEiJ.regRn[0] = (int)(l >>> 32);
        XEiJ.regRn[1] = (int)l;
    }

    public static void fpkATANH() {
        double d = Double.longBitsToDouble((long)XEiJ.regRn[0] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1]);
        QFP.fpsr = 0;
        d = new QFP(d).atanh().getd();
        XEiJ.regCCR = (QFP.fpsr & 0x2400) != 0 ? 1 : 0;
        long l = Double.doubleToLongBits(d);
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        XEiJ.regRn[0] = (int)(l >>> 32);
        XEiJ.regRn[1] = (int)l;
    }

    public static void fpkASIN() {
        double d = Double.longBitsToDouble((long)XEiJ.regRn[0] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1]);
        if (d < -1.0 || 1.0 < d) {
            d = Double.NaN;
            XEiJ.regCCR = 1;
        } else {
            d = Math.asin(d);
            XEiJ.regCCR = 0;
        }
        long l = Double.doubleToLongBits(d);
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        XEiJ.regRn[0] = (int)(l >>> 32);
        XEiJ.regRn[1] = (int)l;
    }

    public static void fpkACOS() {
        double d = Double.longBitsToDouble((long)XEiJ.regRn[0] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1]);
        if (d < -1.0 || 1.0 < d) {
            d = Double.NaN;
            XEiJ.regCCR = 1;
        } else {
            d = Math.acos(d);
            XEiJ.regCCR = 0;
        }
        long l = Double.doubleToLongBits(d);
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        XEiJ.regRn[0] = (int)(l >>> 32);
        XEiJ.regRn[1] = (int)l;
    }

    public static void fpkLOG10() {
        double d = Double.longBitsToDouble((long)XEiJ.regRn[0] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1]);
        double d2 = Math.log10(d);
        long l = Double.doubleToLongBits(d2);
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        XEiJ.regRn[0] = (int)(l >>> 32);
        XEiJ.regRn[1] = (int)l;
        XEiJ.regCCR = Double.isNaN(d) ? 0 : (Double.isNaN(d2) ? 1 : (Double.isInfinite(d) ? 0 : (Double.isInfinite(d2) ? 5 : 0)));
    }

    public static void fpkLOG2() {
        double d = Double.longBitsToDouble((long)XEiJ.regRn[0] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1]);
        double d2 = Math.log(d) / 0.6931471805599453;
        long l = Double.doubleToLongBits(d2);
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        XEiJ.regRn[0] = (int)(l >>> 32);
        XEiJ.regRn[1] = (int)l;
        XEiJ.regCCR = Double.isNaN(d) ? 0 : (Double.isNaN(d2) ? 1 : (Double.isInfinite(d) ? 0 : (Double.isInfinite(d2) ? 5 : 0)));
    }

    public static void fpkDFREXP() {
        int n = XEiJ.regRn[0];
        if (n << 1 == 0 && XEiJ.regRn[1] == 0) {
            XEiJ.regRn[0] = 0;
            XEiJ.regRn[2] = 0;
        } else {
            XEiJ.regRn[0] = n & 0x800FFFFF | 0x3FF00000;
            XEiJ.regRn[2] = (n >>> 20 & 0x7FF) - 1023;
        }
    }

    public static void fpkDLDEXP() {
        int n = XEiJ.regRn[0];
        if (n << 1 == 0 && XEiJ.regRn[1] == 0) {
            XEiJ.regRn[0] = 0;
            XEiJ.regCCR = 0;
        } else {
            int n2 = (n >>> 20 & 0x7FF) + XEiJ.regRn[2];
            if ((n2 & 0xFFFFF800) != 0) {
                XEiJ.regCCR = 1;
            } else {
                XEiJ.regRn[0] = n & 0x800FFFFF | n2 << 20;
                XEiJ.regCCR = 0;
            }
        }
    }

    public static void fpkDADDONE() {
        double d = Double.longBitsToDouble((long)XEiJ.regRn[0] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1]);
        double d2 = d + 1.0;
        long l = Double.doubleToLongBits(d2);
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        XEiJ.regRn[0] = (int)(l >>> 32);
        XEiJ.regRn[1] = (int)l;
        XEiJ.regCCR = Double.isInfinite(d2) && !Double.isInfinite(d) ? 3 : 0;
    }

    public static void fpkDSUBONE() {
        double d = Double.longBitsToDouble((long)XEiJ.regRn[0] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1]);
        double d2 = d - 1.0;
        long l = Double.doubleToLongBits(d2);
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        XEiJ.regRn[0] = (int)(l >>> 32);
        XEiJ.regRn[1] = (int)l;
        XEiJ.regCCR = Double.isInfinite(d2) && !Double.isInfinite(d) ? 3 : 0;
    }

    public static void fpkDDIVTWO() {
        double d = Double.longBitsToDouble((long)XEiJ.regRn[0] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1]);
        double d2 = d * 0.5;
        long l = Double.doubleToLongBits(d2);
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        XEiJ.regRn[0] = (int)(l >>> 32);
        XEiJ.regRn[1] = (int)l;
        XEiJ.regCCR = d2 == 0.0 && d != 0.0 ? 1 : 0;
    }

    public static void fpkDIEECNV() {
    }

    public static void fpkIEEDCNV() {
    }

    public static void fpkFTST() {
        int n = XEiJ.regRn[0];
        XEiJ.regCCR = n << 1 == 0 ? 4 : (0 <= n ? 0 : 8);
    }

    public static void fpkFCMP() {
        float f;
        float f2 = Float.intBitsToFloat(XEiJ.regRn[0]);
        XEiJ.regCCR = f2 < (f = Float.intBitsToFloat(XEiJ.regRn[1])) ? 9 : (f2 == f ? 4 : 0);
    }

    public static void fpkFNEG() {
        int n = Float.floatToIntBits(-Float.intBitsToFloat(XEiJ.regRn[0]));
        if (n == 2143289344) {
            n = Integer.MAX_VALUE;
        }
        XEiJ.regRn[0] = n;
    }

    public static void fpkFADD() {
        float f;
        float f2 = Float.intBitsToFloat(XEiJ.regRn[0]);
        float f3 = f2 + (f = Float.intBitsToFloat(XEiJ.regRn[1]));
        int n = Float.floatToIntBits(f3);
        if (n == 2143289344) {
            n = Integer.MAX_VALUE;
        }
        XEiJ.regRn[0] = n;
        XEiJ.regCCR = Float.isNaN(f2) || Float.isNaN(f) ? 0 : (Float.isNaN(f3) ? 1 : (Float.isInfinite(f2) || Float.isInfinite(f) ? 0 : (Float.isInfinite(f3) ? 3 : 0)));
    }

    public static void fpkFSUB() {
        float f;
        float f2 = Float.intBitsToFloat(XEiJ.regRn[0]);
        float f3 = f2 - (f = Float.intBitsToFloat(XEiJ.regRn[1]));
        int n = Float.floatToIntBits(f3);
        if (n == 2143289344) {
            n = Integer.MAX_VALUE;
        }
        XEiJ.regRn[0] = n;
        XEiJ.regCCR = Float.isNaN(f2) || Float.isNaN(f) ? 0 : (Float.isNaN(f3) ? 1 : (Float.isInfinite(f2) || Float.isInfinite(f) ? 0 : (Float.isInfinite(f3) ? 3 : 0)));
    }

    public static void fpkFMUL() {
        float f;
        float f2 = Float.intBitsToFloat(XEiJ.regRn[0]);
        float f3 = f2 * (f = Float.intBitsToFloat(XEiJ.regRn[1]));
        int n = Float.floatToIntBits(f3);
        if (n == 2143289344) {
            n = Integer.MAX_VALUE;
        }
        XEiJ.regRn[0] = n;
        XEiJ.regCCR = Float.isNaN(f2) || Float.isNaN(f) ? 0 : (Float.isNaN(f3) ? 1 : (Float.isInfinite(f2) || Float.isInfinite(f) ? 0 : (Float.isInfinite(f3) ? 3 : 0)));
    }

    public static void fpkFDIV() {
        float f;
        float f2 = Float.intBitsToFloat(XEiJ.regRn[0]);
        float f3 = f2 / (f = Float.intBitsToFloat(XEiJ.regRn[1]));
        int n = Float.floatToIntBits(f3);
        if (n == 2143289344) {
            n = Integer.MAX_VALUE;
        }
        XEiJ.regRn[0] = n;
        XEiJ.regCCR = Float.isNaN(f2) || Float.isNaN(f) ? 0 : (Float.isNaN(f3) ? 1 : (Float.isInfinite(f2) || Float.isInfinite(f) ? 0 : (f == 0.0f ? 5 : (Float.isInfinite(f3) ? 3 : 0))));
    }

    public static void fpkFMOD() {
        float f;
        float f2 = Float.intBitsToFloat(XEiJ.regRn[0]);
        float f3 = f2 % (f = Float.intBitsToFloat(XEiJ.regRn[1]));
        int n = Float.floatToIntBits(f3);
        if (n == 2143289344) {
            n = Integer.MAX_VALUE;
        }
        XEiJ.regRn[0] = n;
        XEiJ.regCCR = Float.isNaN(f2) || Float.isNaN(f) ? 0 : (f == 0.0f ? 5 : (Float.isNaN(f3) ? 1 : (Float.isInfinite(f2) || Float.isInfinite(f) ? 0 : (Float.isInfinite(f3) ? 3 : 0))));
    }

    public static void fpkFABS() {
        int n = Float.floatToIntBits(Math.abs(Float.intBitsToFloat(XEiJ.regRn[0])));
        if (n == 2143289344) {
            n = Integer.MAX_VALUE;
        }
        XEiJ.regRn[0] = n;
    }

    public static void fpkFCEIL() {
        int n = Float.floatToIntBits((float)Math.ceil(Float.intBitsToFloat(XEiJ.regRn[0])));
        if (n == 2143289344) {
            n = Integer.MAX_VALUE;
        }
        XEiJ.regRn[0] = n;
    }

    public static void fpkFFIX() {
        float f = Float.intBitsToFloat(XEiJ.regRn[0]);
        int n = Float.floatToIntBits(0.0 <= (double)f ? (float)Math.floor(f) : (float)Math.ceil(f));
        if (n == 2143289344) {
            n = Integer.MAX_VALUE;
        }
        XEiJ.regRn[0] = n;
    }

    public static void fpkFFLOOR() {
        int n = Float.floatToIntBits((float)Math.floor(Float.intBitsToFloat(XEiJ.regRn[0])));
        if (n == 2143289344) {
            n = Integer.MAX_VALUE;
        }
        XEiJ.regRn[0] = n;
    }

    public static void fpkFFRAC() {
        int n = XEiJ.regRn[0];
        float f = Float.intBitsToFloat(n);
        int n2 = Float.isNaN(f) ? Float.floatToIntBits(Float.NaN) : (Float.isInfinite(f) ? n & Integer.MIN_VALUE : (n = Float.floatToIntBits(0 <= n ? f - (float)Math.floor(f) : -(-f - (float)Math.floor(-f)))));
        if (n == 2143289344) {
            n = Integer.MAX_VALUE;
        }
        XEiJ.regRn[0] = n;
    }

    public static void fpkFSGN() {
        int n = Float.floatToIntBits(Math.signum(Float.intBitsToFloat(XEiJ.regRn[0])));
        if (n == 2143289344) {
            n = Integer.MAX_VALUE;
        }
        XEiJ.regRn[0] = n;
    }

    public static void fpkFSIN() {
        float f = Float.intBitsToFloat(XEiJ.regRn[0]);
        float f2 = (float)Math.sin(f);
        int n = Float.floatToIntBits(f2);
        if (n == 2143289344) {
            n = Integer.MAX_VALUE;
        }
        XEiJ.regRn[0] = n;
        XEiJ.regCCR = !Float.isNaN(f) && Float.isNaN(f2) ? 1 : 0;
    }

    public static void fpkFCOS() {
        float f = Float.intBitsToFloat(XEiJ.regRn[0]);
        float f2 = (float)Math.cos(f);
        int n = Float.floatToIntBits(f2);
        if (n == 2143289344) {
            n = Integer.MAX_VALUE;
        }
        XEiJ.regRn[0] = n;
        XEiJ.regCCR = !Float.isNaN(f) && Float.isNaN(f2) ? 1 : 0;
    }

    public static void fpkFTAN() {
        float f = Float.intBitsToFloat(XEiJ.regRn[0]);
        float f2 = (float)Math.tan(f);
        int n = Float.floatToIntBits(f2);
        if (n == 2143289344) {
            n = Integer.MAX_VALUE;
        }
        XEiJ.regRn[0] = n;
        XEiJ.regCCR = !Float.isNaN(f) && Float.isNaN(f2) ? 1 : 0;
    }

    public static void fpkFATAN() {
        int n = Float.floatToIntBits((float)Math.atan(Float.intBitsToFloat(XEiJ.regRn[0])));
        if (n == 2143289344) {
            n = Integer.MAX_VALUE;
        }
        XEiJ.regRn[0] = n;
    }

    public static void fpkFLOG() {
        float f = Float.intBitsToFloat(XEiJ.regRn[0]);
        float f2 = (float)Math.log(f);
        int n = Float.floatToIntBits(f2);
        if (n == 2143289344) {
            n = Integer.MAX_VALUE;
        }
        XEiJ.regRn[0] = n;
        XEiJ.regCCR = Float.isNaN(f) ? 0 : (Float.isNaN(f2) ? 1 : (Float.isInfinite(f) ? 0 : (Float.isNaN(f2) ? 5 : 0)));
    }

    public static void fpkFEXP() {
        int n = XEiJ.regRn[0];
        int n2 = Float.floatToIntBits((float)Math.exp(Float.intBitsToFloat(n)));
        if (n2 == 2143289344) {
            n2 = Integer.MAX_VALUE;
        }
        XEiJ.regRn[0] = n2;
        XEiJ.regCCR = (n2 & 0x7FC00000) == 2143289344 && (n & 0x7FC00000) != 2143289344 ? 1 : 0;
    }

    public static void fpkFSQR() {
        float f = Float.intBitsToFloat(XEiJ.regRn[0]);
        int n = Float.floatToIntBits((float)Math.sqrt(f));
        if (n == 2143289344) {
            n = Integer.MAX_VALUE;
        }
        XEiJ.regRn[0] = n;
        XEiJ.regCCR = f < 0.0f ? 1 : 0;
    }

    public static void fpkFPI() {
        XEiJ.regRn[0] = 1078530011;
    }

    public static void fpkFNPI() {
        int n = XEiJ.regRn[0];
        int n2 = Float.floatToIntBits((float)((double)Float.intBitsToFloat(n) * Math.PI));
        if (n2 == 2143289344) {
            n2 = Integer.MAX_VALUE;
        }
        XEiJ.regRn[0] = n2;
        XEiJ.regCCR = (n2 & 0x7FC00000) == 2143289344 && (n & 0x7FC00000) != 2143289344 ? 1 : 0;
    }

    public static void fpkFPOWER() {
        float f;
        float f2 = Float.intBitsToFloat(XEiJ.regRn[0]);
        float f3 = (float)Math.pow(f2, f = Float.intBitsToFloat(XEiJ.regRn[1]));
        int n = Float.floatToIntBits(f3);
        if (n == 2143289344) {
            n = Integer.MAX_VALUE;
        }
        XEiJ.regRn[0] = n;
        XEiJ.regCCR = Float.isNaN(f2) || Float.isNaN(f) ? 0 : (Float.isNaN(f3) ? 1 : (Float.isInfinite(f2) || Float.isInfinite(f) ? 0 : (Float.isNaN(f3) ? 3 : 0)));
    }

    public static void fpkFRND() {
        long l = 0xFFFFFFFFL & (long)FEFunction.fpkRndLong();
        int n = Long.numberOfLeadingZeros(l |= (0x1FFFFFL & (long)FEFunction.fpkRndLong()) << 32) - 11;
        l = ((long)(1021 - n) << 52) + (l << n);
        XEiJ.regRn[0] = Float.floatToIntBits((float)Double.longBitsToDouble(l));
    }

    public static void fpkFSINH() {
        float f = Float.intBitsToFloat(XEiJ.regRn[0]);
        float f2 = (float)Math.sinh(f);
        int n = Float.floatToIntBits(f2);
        if (n == 2143289344) {
            n = Integer.MAX_VALUE;
        }
        XEiJ.regRn[0] = n;
        XEiJ.regCCR = Float.isNaN(f) ? 0 : (Float.isNaN(f2) ? 1 : (Float.isInfinite(f) ? 0 : (Float.isNaN(f2) ? 3 : 0)));
    }

    public static void fpkFCOSH() {
        float f = Float.intBitsToFloat(XEiJ.regRn[0]);
        float f2 = (float)Math.cosh(f);
        int n = Float.floatToIntBits(f2);
        if (n == 2143289344) {
            n = Integer.MAX_VALUE;
        }
        XEiJ.regRn[0] = n;
        XEiJ.regCCR = Float.isNaN(f) ? 0 : (Float.isNaN(f2) ? 1 : (Float.isInfinite(f) ? 0 : (Float.isNaN(f2) ? 3 : 0)));
    }

    public static void fpkFTANH() {
        int n = Float.floatToIntBits((float)Math.tanh(Float.intBitsToFloat(XEiJ.regRn[0])));
        if (n == 2143289344) {
            n = Integer.MAX_VALUE;
        }
        XEiJ.regRn[0] = n;
    }

    public static void fpkFATANH() {
        double d = Float.intBitsToFloat(XEiJ.regRn[0]);
        double d2 = Math.signum(d);
        double d3 = Math.abs(d);
        if (d3 < 1.0) {
            d = d2 * (Math.log1p(d3) - Math.log1p(-d3)) * 0.5;
            XEiJ.regCCR = 0;
        } else if (d3 == 1.0) {
            d = d2 * Double.POSITIVE_INFINITY;
            XEiJ.regCCR = 1;
        } else {
            d = Double.NaN;
            XEiJ.regCCR = 1;
        }
        int n = Float.floatToIntBits((float)d);
        if (n == 2143289344) {
            n = Integer.MAX_VALUE;
        }
        XEiJ.regRn[0] = n;
    }

    public static void fpkFASIN() {
        double d = Float.intBitsToFloat(XEiJ.regRn[0]);
        if (d < -1.0 || 1.0 < d) {
            d = Double.NaN;
            XEiJ.regCCR = 1;
        } else {
            d = Math.asin(d);
            XEiJ.regCCR = 0;
        }
        int n = Float.floatToIntBits((float)d);
        if (n == 2143289344) {
            n = Integer.MAX_VALUE;
        }
        XEiJ.regRn[0] = n;
    }

    public static void fpkFACOS() {
        double d = Float.intBitsToFloat(XEiJ.regRn[0]);
        if (d < -1.0 || 1.0 < d) {
            d = Double.NaN;
            XEiJ.regCCR = 1;
        } else {
            d = Math.acos(d);
            XEiJ.regCCR = 0;
        }
        int n = Float.floatToIntBits((float)d);
        if (n == 2143289344) {
            n = Integer.MAX_VALUE;
        }
        XEiJ.regRn[0] = n;
    }

    public static void fpkFLOG10() {
        double d = Float.intBitsToFloat(XEiJ.regRn[0]);
        double d2 = Math.log10(d);
        int n = Float.floatToIntBits((float)d2);
        if (n == 2143289344) {
            n = Integer.MAX_VALUE;
        }
        XEiJ.regRn[0] = n;
        XEiJ.regCCR = Double.isNaN(d) ? 0 : (Double.isNaN(d2) ? 1 : (Double.isInfinite(d) ? 0 : (Double.isInfinite(d2) ? 5 : 0)));
    }

    public static void fpkFLOG2() {
        double d = Float.intBitsToFloat(XEiJ.regRn[0]);
        double d2 = Math.log(d) / 0.6931471805599453;
        int n = Float.floatToIntBits((float)d2);
        if (n == 2143289344) {
            n = Integer.MAX_VALUE;
        }
        XEiJ.regRn[0] = n;
        XEiJ.regCCR = Double.isNaN(d) ? 0 : (Double.isNaN(d2) ? 1 : (Double.isInfinite(d) ? 0 : (Double.isInfinite(d2) ? 5 : 0)));
    }

    public static void fpkFFREXP() {
        int n = XEiJ.regRn[0];
        if (n << 1 == 0) {
            XEiJ.regRn[0] = 0;
            XEiJ.regRn[1] = 0;
        } else {
            XEiJ.regRn[0] = n & 0x807FFFFF | 0x3F800000;
            XEiJ.regRn[1] = (n >>> 23 & 0xFF) - 127;
        }
    }

    public static void fpkFLDEXP() {
        int n = XEiJ.regRn[0];
        if (n << 1 == 0) {
            XEiJ.regRn[0] = 0;
            XEiJ.regCCR = 0;
        } else {
            int n2 = (n >>> 23 & 0xFF) + XEiJ.regRn[2];
            if ((n2 & 0xFFFFFF00) != 0) {
                XEiJ.regCCR = 1;
            } else {
                XEiJ.regRn[0] = n & 0x807FFFFF | n2 << 23;
                XEiJ.regCCR = 0;
            }
        }
    }

    public static void fpkFADDONE() {
        float f = Float.intBitsToFloat(XEiJ.regRn[0]);
        float f2 = f + 1.0f;
        int n = Float.floatToIntBits(f2);
        if (n == 2143289344) {
            n = Integer.MAX_VALUE;
        }
        XEiJ.regRn[0] = n;
        XEiJ.regCCR = Double.isInfinite(f2) && !Float.isInfinite(f) ? 3 : 0;
    }

    public static void fpkFSUBONE() {
        float f = Float.intBitsToFloat(XEiJ.regRn[0]);
        float f2 = f - 1.0f;
        int n = Float.floatToIntBits(f2);
        if (n == 2143289344) {
            n = Integer.MAX_VALUE;
        }
        XEiJ.regRn[0] = n;
        XEiJ.regCCR = Double.isInfinite(f2) && !Float.isInfinite(f) ? 3 : 0;
    }

    public static void fpkFDIVTWO() {
        float f = Float.intBitsToFloat(XEiJ.regRn[0]);
        float f2 = f * 0.5f;
        int n = Float.floatToIntBits(f2);
        if (n == 2143289344) {
            n = Integer.MAX_VALUE;
        }
        XEiJ.regRn[0] = n;
        XEiJ.regCCR = f2 == 0.0f && f != 0.0f ? 1 : 0;
    }

    public static void fpkFIEECNV() {
    }

    public static void fpkIEEFCNV() {
    }

    public static void fpkFEVARG() {
        XEiJ.regRn[0] = 0x49454545;
        XEiJ.regRn[1] = 1480943946;
    }

    public static void fpkFEVECS() {
        XEiJ.regRn[0] = -1;
    }

    public static void fpkSTOL() throws M68kException {
        int n = XEiJ.regRn[8];
        int n2 = XEiJ.busRbz(n);
        while (n2 == 32 || n2 == 9) {
            n2 = XEiJ.busRbz(++n);
        }
        int n3 = 55;
        if (n2 == 45) {
            n3 = 56;
            n2 = XEiJ.busRbz(++n);
        } else if (n2 == 43) {
            n2 = XEiJ.busRbz(++n);
        }
        if (48 > n2 || n2 > 57) {
            XEiJ.regRn[8] = n;
            XEiJ.regCCR = 9;
            return;
        }
        int n4 = n2 - 48;
        n2 = XEiJ.busRbz(++n);
        while (48 <= n2 && n2 <= 57) {
            if (0xCCCCCCC < n4 || n4 == 0xCCCCCCC && n3 < n2) {
                XEiJ.regRn[8] = n;
                XEiJ.regCCR = 3;
                return;
            }
            n4 = n4 * 10 + (n2 - 48);
            n2 = XEiJ.busRbz(++n);
        }
        if (n3 != 55) {
            n4 = -n4;
        }
        XEiJ.regRn[0] = n4;
        XEiJ.regRn[8] = n;
        XEiJ.regCCR = 0;
    }

    public static void fpkLTOS() throws M68kException {
        int n = XEiJ.regRn[0];
        int n2 = XEiJ.regRn[8];
        if (n < 0) {
            XEiJ.busWb(n2++, 45);
            n = -n;
        }
        long l = XEiJ.fmtBcd12(0xFFFFFFFFL & (long)n);
        XEiJ.regRn[8] = n2 += Math.max(1, 67 - Long.numberOfLeadingZeros(l) >> 2);
        XEiJ.busWb(n2, 0);
        do {
            XEiJ.busWb(--n2, 0x30 | (int)l & 0xF);
        } while ((l >>>= 4) != 0L);
    }

    public static void fpkSTOH() throws M68kException {
        int n = XEiJ.regRn[8];
        int n2 = XEiJ.busRbz(n);
        if (!(48 <= n2 && n2 <= 57 || 65 <= n2 && n2 <= 70 || 97 <= n2 && n2 <= 102)) {
            XEiJ.regRn[8] = n;
            XEiJ.regCCR = 9;
            return;
        }
        int n3 = n2 <= 57 ? n2 - 48 : (n2 <= 70 ? n2 - 55 : n2 - 87);
        n2 = XEiJ.busRbz(++n);
        while (48 <= n2 && n2 <= 57 || 65 <= n2 && n2 <= 70 || 97 <= n2 && n2 <= 102) {
            if (0xFFFFFFF < n3) {
                XEiJ.regRn[8] = n;
                XEiJ.regCCR = 3;
                return;
            }
            n3 = n3 << 4 | (n2 <= 57 ? n2 - 48 : (n2 <= 70 ? n2 - 55 : n2 - 87));
            n2 = XEiJ.busRbz(++n);
        }
        XEiJ.regRn[0] = n3;
        XEiJ.regRn[8] = n;
        XEiJ.regCCR = 0;
    }

    public static void fpkHTOS() throws M68kException {
        int n = XEiJ.regRn[0];
        int n2 = XEiJ.regRn[8] = XEiJ.regRn[8] + Math.max(1, 35 - Integer.numberOfLeadingZeros(n) >> 2);
        XEiJ.busWb(n2, 0);
        do {
            int n3 = n & 0xF;
            XEiJ.busWb(--n2, (9 - n3 >> 4 & 7 | 0x30) + n3);
        } while ((n >>>= 4) != 0);
    }

    public static void fpkSTOO() throws M68kException {
        int n = XEiJ.regRn[8];
        int n2 = XEiJ.busRbz(n);
        if (48 > n2 || n2 > 55) {
            XEiJ.regRn[8] = n;
            XEiJ.regCCR = 9;
            return;
        }
        int n3 = n2 - 48;
        n2 = XEiJ.busRbz(++n);
        while (48 <= n2 && n2 <= 55) {
            if (0x1FFFFFFF < n3) {
                XEiJ.regRn[8] = n;
                XEiJ.regCCR = 3;
                return;
            }
            n3 = n3 << 3 | n2 & 7;
            n2 = XEiJ.busRbz(++n);
        }
        XEiJ.regRn[0] = n3;
        XEiJ.regRn[8] = n;
        XEiJ.regCCR = 0;
    }

    public static void fpkOTOS() throws M68kException {
        int n = XEiJ.regRn[0];
        int n2 = XEiJ.regRn[8] = XEiJ.regRn[8] + Math.max(1, (34 - Integer.numberOfLeadingZeros(n)) * 43 >>> 7);
        XEiJ.busWb(n2, 0);
        do {
            XEiJ.busWb(--n2, 0x30 | n & 7);
        } while ((n >>>= 3) != 0);
    }

    public static void fpkSTOB() throws M68kException {
        int n = XEiJ.regRn[8];
        int n2 = XEiJ.busRbz(n);
        if (48 > n2 || n2 > 49) {
            XEiJ.regRn[8] = n;
            XEiJ.regCCR = 9;
            return;
        }
        int n3 = n2 - 48;
        n2 = XEiJ.busRbz(++n);
        while (48 <= n2 && n2 <= 49) {
            if (n3 < 0) {
                XEiJ.regRn[8] = n;
                XEiJ.regCCR = 3;
                return;
            }
            n3 = n3 << 1 | n2 & 1;
            n2 = XEiJ.busRbz(++n);
        }
        XEiJ.regRn[0] = n3;
        XEiJ.regRn[8] = n;
        XEiJ.regCCR = 0;
    }

    public static void fpkBTOS() throws M68kException {
        int n = XEiJ.regRn[0];
        int n2 = XEiJ.regRn[8] = XEiJ.regRn[8] + Math.max(1, 32 - Integer.numberOfLeadingZeros(n));
        XEiJ.busWb(n2, 0);
        do {
            XEiJ.busWb(--n2, 0x30 | n & 1);
        } while ((n >>>= 1) != 0);
    }

    public static void fpkIUSING() throws M68kException {
        int n = XEiJ.regRn[0];
        int n2 = 0;
        if (n < 0) {
            n2 = 1;
            n = -n;
        }
        long l = XEiJ.fmtBcd12(0xFFFFFFFFL & (long)n);
        int n3 = n2 + Math.max(1, 67 - Long.numberOfLeadingZeros(l) >> 2);
        int n4 = XEiJ.regRn[8];
        for (int i = (XEiJ.regRn[1] & 0xFF) - n3; i > 0; --i) {
            XEiJ.busWb(n4++, 32);
        }
        XEiJ.regRn[8] = n4 += n3;
        XEiJ.busWb(n4, 0);
        do {
            XEiJ.busWb(--n4, 0x30 | (int)l & 0xF);
        } while ((l >>>= 4) != 0L);
        if (n2 != 0) {
            XEiJ.busWb(--n4, 45);
        }
    }

    public static void fpkVAL() throws M68kException {
        int n = XEiJ.regRn[8];
        int n2 = XEiJ.busRbs(n++);
        while (n2 == 32 || n2 == 9) {
            n2 = XEiJ.busRbs(n++);
        }
        if (n2 == 38) {
            n2 = XEiJ.busRbs(n++) & 0xDF;
            XEiJ.regRn[8] = n;
            if (n2 == 66) {
                FEFunction.fpkSTOB();
                FEFunction.fpkLTOD();
            } else if (n2 == 79) {
                FEFunction.fpkSTOO();
                FEFunction.fpkLTOD();
            } else if (n2 == 72) {
                FEFunction.fpkSTOH();
                FEFunction.fpkLTOD();
            } else {
                XEiJ.regCCR = 9;
            }
        } else {
            FEFunction.fpkSTOD();
        }
    }

    public static void fpkUSING() throws M68kException {
        FEFunction.fpkUSINGSub((long)XEiJ.regRn[0] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1]);
    }

    public static void fpkUSINGSub(long l) throws M68kException {
        int n;
        int n2;
        int n3;
        int n4 = XEiJ.regRn[4];
        int n5 = ((n4 & 0x18) == 16 ? 1 : 0) + Math.max(0, XEiJ.regRn[2]);
        int n6 = Math.max(-1, XEiJ.regRn[3]);
        int n7 = XEiJ.regRn[8];
        boolean bl = (n4 & 8) != 0;
        int n8 = (n4 & 1) != 0 ? 42 : 32;
        int n9 = (n4 & 2) != 0 ? 92 : 0;
        int n10 = !bl && (n4 & 4) != 0 ? 44 : 0;
        int n11 = 0;
        int n12 = 0;
        if (l < 0L) {
            if ((n4 & 0x60) == 0) {
                n11 = 45;
            } else {
                n12 = 45;
            }
            l &= Long.MAX_VALUE;
        } else if ((n4 & 0x10) != 0) {
            n11 = 43;
        } else if ((n4 & 0x30) == 32) {
            n12 = 43;
        } else if ((n4 & 0x70) == 64) {
            n12 = 32;
        }
        double d = Double.longBitsToDouble(l);
        int n13 = (int)(l >>> 52) - 1023;
        l &= 0xFFFFFFFFFFFFFL;
        if (n13 == -1023) {
            if (l == 0L) {
                for (int i = n5 - ((n11 != 0 ? 1 : 0) + (n9 != 0 ? 1 : 0) + 1); 0 < i; --i) {
                    XEiJ.busWb(n7++, n8);
                }
                if (n11 != 0) {
                    XEiJ.busWb(n7++, n11);
                }
                if (n9 != 0) {
                    XEiJ.busWb(n7++, n9);
                }
                if (0 < n5) {
                    XEiJ.busWb(n7++, 48);
                }
                if (0 <= n6) {
                    XEiJ.busWb(n7++, 46);
                    while (0 < n6) {
                        XEiJ.busWb(n7++, 48);
                        --n6;
                    }
                }
                XEiJ.busWb(n7, 0);
                return;
            }
            n13 -= Long.numberOfLeadingZeros(l) - 12;
        } else if (n13 == 1024) {
            for (int i = n5 + 1 + n6 + (bl ? 5 : 0) - ((n11 != 0 ? 1 : 0) + (n9 != 0 ? 1 : 0) + 4); 0 < i; --i) {
                XEiJ.busWb(n7++, n8);
            }
            if (n11 != 0) {
                XEiJ.busWb(n7++, n11);
            }
            if (n9 != 0) {
                XEiJ.busWb(n7++, n9);
            }
            XEiJ.busWb(n7++, 35);
            if (l == 0L) {
                XEiJ.busWb(n7++, 73);
                XEiJ.busWb(n7++, 78);
                XEiJ.busWb(n7++, 70);
            } else {
                XEiJ.busWb(n7++, 78);
                XEiJ.busWb(n7++, 65);
                XEiJ.busWb(n7++, 78);
            }
            XEiJ.busWb(n7, 0);
            return;
        }
        n13 = (int)Math.floor((double)n13 * 0.3010299956639812);
        if (0 < n13) {
            d *= FPK_TEN_M16QR[n13 & 0xF];
            if (16 <= n13) {
                d *= FPK_TEN_M16QR[16 + (n13 >> 4 & 0xF)];
                if (256 <= n13) {
                    d *= FPK_TEN_M16QR[33];
                }
            }
        } else if (n13 < 0) {
            d *= FPK_TEN_P16QR[-n13 & 0xF];
            if (n13 <= -16) {
                d *= FPK_TEN_P16QR[16 + (-n13 >> 4 & 0xF)];
                if (n13 <= -256) {
                    d *= FPK_TEN_P16QR[33];
                }
            }
        }
        int[] nArray = new int[18];
        int n14 = (int)d;
        int n15 = XEiJ.FMT_BCD4[n14];
        nArray[0] = n15 >> 4;
        nArray[1] = n15 & 0xF;
        for (n3 = 2; n3 < 18; n3 += 4) {
            double d2 = d * 1.34217729E8;
            d2 += d - d2;
            d = (d2 - (double)n14) * 10000.0 + (d - d2) * 10000.0;
            n14 = (int)d;
            n15 = XEiJ.FMT_BCD4[n14];
            nArray[n3] = n15 >> 12;
            nArray[n3 + 1] = n15 >> 8 & 0xF;
            nArray[n3 + 2] = n15 >> 4 & 0xF;
            nArray[n3 + 3] = n15 & 0xF;
        }
        n14 = nArray[0] != 0 ? 0 : (nArray[1] != 0 ? 1 : 2);
        n15 = n14 + 14;
        if (5 <= nArray[n15]) {
            n3 = n15;
            while (true) {
                int n16 = --n3;
                nArray[n16] = nArray[n16] + 1;
                if (10 > nArray[n16]) break;
                nArray[n3] = 0;
            }
            if (n3 < n14) {
                --n14;
                --n15;
            }
        }
        if ((n2 = n14 + (n3 = !bl ? (n13 -= n14 - 1) : Math.max(0, n11 != 0 || n12 != 0 ? n5 : n5 - 1) - 1) + 1 + Math.max(0, n6)) < n15 && 0 <= (n15 = n2) && 5 <= nArray[n15]) {
            n = n15;
            while (true) {
                int n17 = --n;
                nArray[n17] = nArray[n17] + 1;
                if (10 > nArray[n17]) break;
                nArray[n] = 0;
            }
            if (n < n14) {
                --n14;
                if (!bl) {
                    ++n3;
                } else {
                    ++n13;
                    --n15;
                }
            }
        }
        if (0 <= n3) {
            for (n = n5 - ((n11 != 0 ? 1 : 0) + (n9 != 0 ? 1 : 0) + (n10 != 0 ? n3 / 3 : 0) + n3 + 1); 0 < n; --n) {
                XEiJ.busWb(n7++, n8);
            }
            if (n11 != 0) {
                XEiJ.busWb(n7++, n11);
            }
            if (n9 != 0) {
                XEiJ.busWb(n7++, n9);
            }
            for (n = n3; 0 <= n; --n) {
                XEiJ.busWb(n7++, n14 < n15 ? 48 + nArray[n14] : 48);
                ++n14;
                if (n10 == 0 || 0 >= n || n % 3 != 0) continue;
                XEiJ.busWb(n7++, n10);
            }
            if (0 <= n6) {
                XEiJ.busWb(n7++, 46);
                while (0 < n6) {
                    XEiJ.busWb(n7++, n14 < n15 ? 48 + nArray[n14] : 48);
                    ++n14;
                    --n6;
                }
            }
        } else {
            for (n = n5 - ((n11 != 0 ? 1 : 0) + (n9 != 0 ? 1 : 0) + 1); 0 < n; --n) {
                XEiJ.busWb(n7++, n8);
            }
            if (n11 != 0) {
                XEiJ.busWb(n7++, n11);
            }
            if (n9 != 0) {
                XEiJ.busWb(n7++, n9);
            }
            if (0 < n5) {
                XEiJ.busWb(n7++, 48);
            }
            if (0 <= n6) {
                XEiJ.busWb(n7++, 46);
                for (n = -1 - n3; 0 < n6 && 0 < n; --n6, --n) {
                    XEiJ.busWb(n7++, 48);
                }
                while (0 < n6) {
                    XEiJ.busWb(n7++, n14 < n15 ? 48 + nArray[n14] : 48);
                    ++n14;
                    --n6;
                }
            }
        }
        if (bl) {
            XEiJ.busWb(n7++, 69);
            if (0 <= (n13 -= n3)) {
                XEiJ.busWb(n7++, 43);
            } else {
                XEiJ.busWb(n7++, 45);
                n13 = -n13;
            }
            n13 = XEiJ.FMT_BCD4[n13];
            XEiJ.busWb(n7++, 48 + (n13 >> 8));
            XEiJ.busWb(n7++, 48 + (n13 >> 4 & 0xF));
            XEiJ.busWb(n7++, 48 + (n13 & 0xF));
        }
        if (n12 != 0) {
            XEiJ.busWb(n7++, n12);
        }
        XEiJ.busWb(n7, 0);
    }

    public static void fpkSTOD() throws M68kException {
        long l = Double.doubleToLongBits(FEFunction.fpkSTODSub());
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        XEiJ.regRn[0] = (int)(l >> 32);
        XEiJ.regRn[1] = (int)l;
    }

    public static double fpkSTODSub() throws M68kException {
        int n = XEiJ.regRn[8];
        int n2 = XEiJ.busRbs(n);
        while (n2 == 32 || n2 == 9) {
            n2 = XEiJ.busRbs(++n);
        }
        double d = 1.0;
        if (n2 == 43) {
            n2 = XEiJ.busRbs(++n);
        } else if (n2 == 45) {
            d = -d;
            n2 = XEiJ.busRbs(++n);
        }
        if (n2 == 35) {
            n2 = XEiJ.busRbs(n + 1);
            if (!(n2 != 78 && n2 != 73 || (n2 = n2 << 8 | XEiJ.busRbz(n + 2)) != 20033 && n2 != 18766 || (n2 = n2 << 8 | XEiJ.busRbz(n + 3)) != 0x4E414E && n2 != 4804166)) {
                XEiJ.regRn[2] = 0;
                XEiJ.regRn[3] = 0;
                XEiJ.regRn[8] = n + 4;
                XEiJ.regCCR = 0;
                return n2 == 0x4E414E ? Double.NaN : d * Double.POSITIVE_INFINITY;
            }
            XEiJ.regRn[8] = n;
            XEiJ.regCCR = 9;
            return 0.0;
        }
        long l = 0L;
        int n3 = 0;
        int n4 = 1;
        if (n2 == 46) {
            n4 = 0;
            n2 = XEiJ.busRbs(++n);
        }
        if (n2 < 48 || 57 < n2) {
            XEiJ.regRn[8] = n;
            XEiJ.regCCR = 9;
            return 0.0;
        }
        double d2 = 0.0;
        do {
            if (0 < n3 || 48 < n2) {
                ++n3;
            }
            if (n4 <= 0 && n3 <= 18) {
                --n4;
            }
            if (0 < n3 && n3 <= 18) {
                l = l * 10L + (long)(n2 - 48);
            }
            n2 = XEiJ.busRbs(++n);
            if (0 >= n4 || n2 != 46) continue;
            n4 = 0;
            n2 = XEiJ.busRbs(++n);
        } while (48 <= n2 && n2 <= 57);
        if (0 < n4) {
            int n5 = n4 = 18 < n3 ? n3 - 18 : 0;
        }
        if (n2 == 69 || n2 == 101) {
            n2 = XEiJ.busRbs(++n);
            int n6 = 1;
            if (n2 == 43) {
                n2 = XEiJ.busRbs(++n);
            } else if (n2 == 45) {
                n6 = -n6;
                n2 = XEiJ.busRbs(++n);
            }
            if (n2 < 48 || 57 < n2) {
                XEiJ.regRn[8] = n;
                XEiJ.regCCR = 9;
                return 0.0;
            }
            while (n2 == 48) {
                n2 = XEiJ.busRbs(++n);
            }
            int n7 = 0;
            for (int i = 0; 48 <= n2 && n2 <= 57 && i < 9; ++i) {
                n7 = n7 * 10 + (n2 - 48);
                n2 = XEiJ.busRbs(++n);
            }
            n4 += n6 * n7;
        }
        if (n4 < -350) {
            XEiJ.regRn[2] = 65535;
            XEiJ.regRn[3] = 0;
            XEiJ.regRn[8] = n;
            XEiJ.regCCR = 0;
            return d < 0.0 ? -0.0 : 0.0;
        }
        if (350 < n4) {
            XEiJ.regRn[2] = 0;
            XEiJ.regRn[3] = 0;
            XEiJ.regRn[8] = n;
            XEiJ.regCCR = 3;
            return d * Double.POSITIVE_INFINITY;
        }
        QFP qFP = new QFP(d < 0.0 ? -l : l);
        if (0 < n4) {
            qFP.mul(QFP.QFP_TEN_P16QR[n4 & 0xF]);
            if (16 <= n4) {
                qFP.mul(QFP.QFP_TEN_P16QR[16 + (n4 >> 4 & 0xF)]);
                if (256 <= n4) {
                    qFP.mul(QFP.QFP_TEN_P16QR[33]);
                }
            }
        } else if (n4 < 0) {
            qFP.mul(QFP.QFP_TEN_M16QR[-n4 & 0xF]);
            if (n4 <= -16) {
                qFP.mul(QFP.QFP_TEN_M16QR[16 + (-n4 >> 4 & 0xF)]);
                if (n4 <= -256) {
                    qFP.mul(QFP.QFP_TEN_M16QR[33]);
                }
            }
        }
        if (Double.isInfinite(d2 = qFP.getd())) {
            XEiJ.regRn[8] = n;
            XEiJ.regCCR = 3;
            return d2;
        }
        if (d2 == (double)((int)d2)) {
            XEiJ.regRn[2] = 65535;
            XEiJ.regRn[3] = (int)d2;
        } else {
            XEiJ.regRn[2] = 0;
            XEiJ.regRn[3] = 0;
        }
        XEiJ.regRn[8] = n;
        XEiJ.regCCR = 0;
        return d2;
    }

    public static void fpkDTOS() throws M68kException {
        FEFunction.fpkDTOSSub((long)XEiJ.regRn[0] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1]);
    }

    public static void fpkDTOSSub(long l) throws M68kException {
        int n;
        int n2 = XEiJ.regRn[8];
        if (l < 0L) {
            XEiJ.busWb(n2++, 45);
            l &= Long.MAX_VALUE;
        }
        double d = Double.longBitsToDouble(l);
        int n3 = (int)(l >>> 52) - 1023;
        l &= 0xFFFFFFFFFFFFFL;
        if (n3 == -1023) {
            if (l == 0L) {
                XEiJ.busWb(n2++, 48);
                XEiJ.busWb(n2, 0);
                XEiJ.regRn[8] = n2;
                return;
            }
            n3 -= Long.numberOfLeadingZeros(l) - 12;
        } else if (n3 == 1024) {
            XEiJ.busWb(n2++, 35);
            if (l == 0L) {
                XEiJ.busWb(n2++, 73);
                XEiJ.busWb(n2++, 78);
                XEiJ.busWb(n2++, 70);
            } else {
                XEiJ.busWb(n2++, 78);
                XEiJ.busWb(n2++, 65);
                XEiJ.busWb(n2++, 78);
            }
            XEiJ.busWb(n2, 0);
            XEiJ.regRn[8] = n2;
            return;
        }
        n3 = (int)Math.floor((double)n3 * 0.3010299956639812);
        if (0 < n3) {
            d *= FPK_TEN_M16QR[n3 & 0xF];
            if (16 <= n3) {
                d *= FPK_TEN_M16QR[16 + (n3 >> 4 & 0xF)];
                if (256 <= n3) {
                    d *= FPK_TEN_M16QR[33];
                }
            }
        } else if (n3 < 0) {
            d *= FPK_TEN_P16QR[-n3 & 0xF];
            if (n3 <= -16) {
                d *= FPK_TEN_P16QR[16 + (-n3 >> 4 & 0xF)];
                if (n3 <= -256) {
                    d *= FPK_TEN_P16QR[33];
                }
            }
        }
        int[] nArray = new int[18];
        int n4 = (int)d;
        int n5 = XEiJ.FMT_BCD4[n4];
        nArray[0] = n5 >> 4;
        nArray[1] = n5 & 0xF;
        for (n = 2; n < 18; n += 4) {
            double d2 = d * 1.34217729E8;
            d2 += d - d2;
            d = (d2 - (double)n4) * 10000.0 + (d - d2) * 10000.0;
            n4 = (int)d;
            n5 = XEiJ.FMT_BCD4[n4];
            nArray[n] = n5 >> 12;
            nArray[n + 1] = n5 >> 8 & 0xF;
            nArray[n + 2] = n5 >> 4 & 0xF;
            nArray[n + 3] = n5 & 0xF;
        }
        n4 = nArray[0] != 0 ? 0 : (nArray[1] != 0 ? 1 : 2);
        n5 = n4 + 14;
        if (5 <= nArray[n5]) {
            n = n5;
            while (true) {
                int n6 = --n;
                nArray[n6] = nArray[n6] + 1;
                if (10 > nArray[n6]) break;
                nArray[n] = 0;
            }
            if (n < n4) {
                --n4;
                --n5;
            }
        }
        n3 -= n4 - 1;
        while (nArray[n5 - 1] == 0) {
            --n5;
        }
        if (0 <= n3 && n3 < 14) {
            while (0 <= n3 && n4 < n5) {
                XEiJ.busWb(n2++, 48 + nArray[n4++]);
                --n3;
            }
            while (0 <= n3) {
                XEiJ.busWb(n2++, 48);
                --n3;
            }
            if (n4 < n5) {
                XEiJ.busWb(n2++, 46);
                do {
                    XEiJ.busWb(n2++, 48 + nArray[n4++]);
                } while (n4 < n5);
            }
        } else if (-4 <= n3 && n3 < 0) {
            XEiJ.busWb(n2++, 48);
            XEiJ.busWb(n2++, 46);
            while (++n3 < 0) {
                XEiJ.busWb(n2++, 48);
            }
            do {
                XEiJ.busWb(n2++, 48 + nArray[n4++]);
            } while (n4 < n5);
        } else {
            XEiJ.busWb(n2++, 48 + nArray[n4++]);
            if (n4 < n5) {
                XEiJ.busWb(n2++, 46);
                do {
                    XEiJ.busWb(n2++, 48 + nArray[n4++]);
                } while (n4 < n5);
            }
            XEiJ.busWb(n2++, 69);
            if (0 <= n3) {
                XEiJ.busWb(n2++, 43);
            } else {
                XEiJ.busWb(n2++, 45);
                n3 = -n3;
            }
            n3 = XEiJ.FMT_BCD4[n3];
            XEiJ.busWb(n2++, 48 + (n3 >> 8));
            XEiJ.busWb(n2++, 48 + (n3 >> 4 & 0xF));
            XEiJ.busWb(n2++, 48 + (n3 & 0xF));
        }
        XEiJ.busWb(n2, 0);
        XEiJ.regRn[8] = n2;
    }

    public static void fpkECVT() throws M68kException {
        FEFunction.fpkECVTSub((long)XEiJ.regRn[0] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1]);
    }

    public static void fpkECVTSub(long l) throws M68kException {
        int n;
        int n2 = XEiJ.regRn[2];
        int n3 = XEiJ.regRn[8];
        if (n2 <= 0) {
            XEiJ.busWb(n3, 0);
            return;
        }
        int n4 = n3 + n2;
        if (0L <= l) {
            XEiJ.regRn[1] = 0;
        } else {
            XEiJ.regRn[1] = 1;
            l &= Long.MAX_VALUE;
        }
        double d = Double.longBitsToDouble(l);
        int n5 = (int)(l >>> 52) - 1023;
        l &= 0xFFFFFFFFFFFFFL;
        if (n5 == -1023) {
            if (l == 0L) {
                while (n3 < n4) {
                    XEiJ.busWb(n3++, 48);
                }
                XEiJ.busWb(n3, 0);
                XEiJ.regRn[0] = 1;
                return;
            }
            n5 -= Long.numberOfLeadingZeros(l) - 12;
        } else if (n5 == 1024) {
            int n6;
            int n7 = n6 = l != 0L ? 1312902691 : 1179535651;
            while (n3 < n4 && n6 != 0) {
                XEiJ.busWb(n3++, n6);
                n6 >>>= 8;
            }
            while (n3 < n4) {
                XEiJ.busWb(n3++, 0);
            }
            XEiJ.busWb(n3, 0);
            XEiJ.regRn[0] = 4;
            return;
        }
        n5 = (int)Math.floor((double)n5 * 0.3010299956639812);
        if (0 < n5) {
            d *= FPK_TEN_M16QR[n5 & 0xF];
            if (16 <= n5) {
                d *= FPK_TEN_M16QR[16 + (n5 >> 4 & 0xF)];
                if (256 <= n5) {
                    d *= FPK_TEN_M16QR[33];
                }
            }
        } else if (n5 < 0) {
            d *= FPK_TEN_P16QR[-n5 & 0xF];
            if (n5 <= -16) {
                d *= FPK_TEN_P16QR[16 + (-n5 >> 4 & 0xF)];
                if (n5 <= -256) {
                    d *= FPK_TEN_P16QR[33];
                }
            }
        }
        int[] nArray = new int[18];
        int n8 = (int)d;
        int n9 = XEiJ.FMT_BCD4[n8];
        nArray[0] = n9 >> 4;
        nArray[1] = n9 & 0xF;
        for (n = 2; n < 18; n += 4) {
            double d2 = d * 1.34217729E8;
            d2 += d - d2;
            d = (d2 - (double)n8) * 10000.0 + (d - d2) * 10000.0;
            n8 = (int)d;
            n9 = XEiJ.FMT_BCD4[n8];
            nArray[n] = n9 >> 12;
            nArray[n + 1] = n9 >> 8 & 0xF;
            nArray[n + 2] = n9 >> 4 & 0xF;
            nArray[n + 3] = n9 & 0xF;
        }
        n8 = nArray[0] != 0 ? 0 : (nArray[1] != 0 ? 1 : 2);
        n9 = n8 + 14;
        if (5 <= nArray[n9]) {
            n = n9;
            while (true) {
                int n10 = --n;
                nArray[n10] = nArray[n10] + 1;
                if (10 > nArray[n10]) break;
                nArray[n] = 0;
            }
            if (n < n8) {
                --n8;
                --n9;
            }
        }
        n5 -= n8 - 1;
        n = n8 + n2;
        if (n < n9 && 0 <= (n9 = n) && 5 <= nArray[n9]) {
            int n11 = n9;
            while (true) {
                int n12 = --n11;
                nArray[n12] = nArray[n12] + 1;
                if (10 > nArray[n12]) break;
                nArray[n11] = 0;
            }
            if (n11 < n8) {
                --n8;
                --n9;
                ++n5;
            }
        }
        while (n3 < n4 && n8 < n9) {
            XEiJ.busWb(n3++, 48 + nArray[n8++]);
        }
        while (n3 < n4) {
            XEiJ.busWb(n3++, 48);
        }
        XEiJ.busWb(n3, 0);
        XEiJ.regRn[0] = n5 + 1;
    }

    public static void fpkFCVT() throws M68kException {
        FEFunction.fpkFCVTSub((long)XEiJ.regRn[0] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1]);
    }

    public static void fpkFCVTSub(long l) throws M68kException {
        int n;
        int n2 = Math.max(0, XEiJ.regRn[2]);
        int n3 = XEiJ.regRn[8];
        if (0L <= l) {
            XEiJ.regRn[1] = 0;
        } else {
            XEiJ.regRn[1] = 1;
            l &= Long.MAX_VALUE;
        }
        double d = Double.longBitsToDouble(l);
        int n4 = (int)(l >>> 52) - 1023;
        l &= 0xFFFFFFFFFFFFFL;
        if (n4 == -1023) {
            if (l == 0L) {
                while (n2-- > 0) {
                    XEiJ.busWb(n3++, 48);
                }
                XEiJ.busWb(n3, 0);
                XEiJ.regRn[0] = 0;
                return;
            }
            n4 -= Long.numberOfLeadingZeros(l) - 12;
        } else if (n4 == 1024) {
            XEiJ.busWb(n3++, 35);
            if (l == 0L) {
                XEiJ.busWb(n3++, 73);
                XEiJ.busWb(n3++, 78);
                XEiJ.busWb(n3++, 70);
            } else {
                XEiJ.busWb(n3++, 78);
                XEiJ.busWb(n3++, 65);
                XEiJ.busWb(n3++, 78);
            }
            XEiJ.busWb(n3, 0);
            XEiJ.regRn[0] = 4;
            return;
        }
        n4 = (int)Math.floor((double)n4 * 0.3010299956639812);
        if (0 < n4) {
            d *= FPK_TEN_M16QR[n4 & 0xF];
            if (16 <= n4) {
                d *= FPK_TEN_M16QR[16 + (n4 >> 4 & 0xF)];
                if (256 <= n4) {
                    d *= FPK_TEN_M16QR[33];
                }
            }
        } else if (n4 < 0) {
            d *= FPK_TEN_P16QR[-n4 & 0xF];
            if (n4 <= -16) {
                d *= FPK_TEN_P16QR[16 + (-n4 >> 4 & 0xF)];
                if (n4 <= -256) {
                    d *= FPK_TEN_P16QR[33];
                }
            }
        }
        int[] nArray = new int[18];
        int n5 = (int)d;
        int n6 = XEiJ.FMT_BCD4[n5];
        nArray[0] = n6 >> 4;
        nArray[1] = n6 & 0xF;
        for (n = 2; n < 18; n += 4) {
            double d2 = d * 1.34217729E8;
            d2 += d - d2;
            d = (d2 - (double)n5) * 10000.0 + (d - d2) * 10000.0;
            n5 = (int)d;
            n6 = XEiJ.FMT_BCD4[n5];
            nArray[n] = n6 >> 12;
            nArray[n + 1] = n6 >> 8 & 0xF;
            nArray[n + 2] = n6 >> 4 & 0xF;
            nArray[n + 3] = n6 & 0xF;
        }
        n5 = nArray[0] != 0 ? 0 : (nArray[1] != 0 ? 1 : 2);
        n6 = n5 + 14;
        if (5 <= nArray[n6]) {
            n = n6;
            while (true) {
                int n7 = --n;
                nArray[n7] = nArray[n7] + 1;
                if (10 > nArray[n7]) break;
                nArray[n] = 0;
            }
            if (n < n5) {
                --n5;
                --n6;
            }
        }
        if ((n = n5 + (n4 -= n5 - 1) + 1 + n2) < n6 && 0 <= (n6 = n) && 5 <= nArray[n6]) {
            int n8 = n6;
            while (true) {
                int n9 = --n8;
                nArray[n9] = nArray[n9] + 1;
                if (10 > nArray[n9]) break;
                nArray[n8] = 0;
            }
            if (n8 < n5) {
                --n5;
                --n6;
                ++n4;
            }
        }
        while (n5 < n6) {
            XEiJ.busWb(n3++, 48 + nArray[n5++]);
        }
        while (n5++ < n) {
            XEiJ.busWb(n3++, 48);
        }
        XEiJ.busWb(n3, 0);
        XEiJ.regRn[0] = n4 + 1;
    }

    public static void fpkGCVT() throws M68kException {
        FEFunction.fpkGCVTSub((long)XEiJ.regRn[0] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1]);
    }

    public static void fpkGCVTSub(long l) throws M68kException {
        int n;
        int n2 = XEiJ.regRn[2];
        int n3 = XEiJ.regRn[8];
        if (n2 <= 0) {
            XEiJ.busWb(n3, 0);
            return;
        }
        if (l < 0L) {
            XEiJ.busWb(n3++, 45);
            l &= Long.MAX_VALUE;
        }
        double d = Double.longBitsToDouble(l);
        int n4 = (int)(l >>> 52) - 1023;
        l &= 0xFFFFFFFFFFFFFL;
        if (n4 == -1023) {
            if (l == 0L) {
                XEiJ.busWb(n3++, 48);
                XEiJ.busWb(n3++, 46);
                XEiJ.busWb(n3, 0);
                XEiJ.regRn[8] = n3;
                return;
            }
            n4 -= Long.numberOfLeadingZeros(l) - 12;
        } else if (n4 == 1024) {
            XEiJ.busWb(n3++, 35);
            if (l == 0L) {
                XEiJ.busWb(n3++, 73);
                XEiJ.busWb(n3++, 78);
                XEiJ.busWb(n3++, 70);
            } else {
                XEiJ.busWb(n3++, 78);
                XEiJ.busWb(n3++, 65);
                XEiJ.busWb(n3++, 78);
            }
            XEiJ.busWb(n3, 0);
            XEiJ.regRn[8] = n3;
            return;
        }
        n4 = (int)Math.floor((double)n4 * 0.3010299956639812);
        if (0 < n4) {
            d *= FPK_TEN_M16QR[n4 & 0xF];
            if (16 <= n4) {
                d *= FPK_TEN_M16QR[16 + (n4 >> 4 & 0xF)];
                if (256 <= n4) {
                    d *= FPK_TEN_M16QR[33];
                }
            }
        } else if (n4 < 0) {
            d *= FPK_TEN_P16QR[-n4 & 0xF];
            if (n4 <= -16) {
                d *= FPK_TEN_P16QR[16 + (-n4 >> 4 & 0xF)];
                if (n4 <= -256) {
                    d *= FPK_TEN_P16QR[33];
                }
            }
        }
        int[] nArray = new int[18];
        int n5 = (int)d;
        int n6 = XEiJ.FMT_BCD4[n5];
        nArray[0] = n6 >> 4;
        nArray[1] = n6 & 0xF;
        for (n = 2; n < 18; n += 4) {
            double d2 = d * 1.34217729E8;
            d2 += d - d2;
            d = (d2 - (double)n5) * 10000.0 + (d - d2) * 10000.0;
            n5 = (int)d;
            n6 = XEiJ.FMT_BCD4[n5];
            nArray[n] = n6 >> 12;
            nArray[n + 1] = n6 >> 8 & 0xF;
            nArray[n + 2] = n6 >> 4 & 0xF;
            nArray[n + 3] = n6 & 0xF;
        }
        n5 = nArray[0] != 0 ? 0 : (nArray[1] != 0 ? 1 : 2);
        n6 = n5 + 14;
        if (5 <= nArray[n6]) {
            n = n6;
            while (true) {
                int n7 = --n;
                nArray[n7] = nArray[n7] + 1;
                if (10 > nArray[n7]) break;
                nArray[n] = 0;
            }
            if (n < n5) {
                --n5;
                --n6;
            }
        }
        n4 -= n5 - 1;
        n = n5 + n2;
        if (n < n6 && 0 <= (n6 = n) && 5 <= nArray[n6]) {
            int n8 = n6;
            while (true) {
                int n9 = --n8;
                nArray[n9] = nArray[n9] + 1;
                if (10 > nArray[n9]) break;
                nArray[n8] = 0;
            }
            if (n8 < n5) {
                --n5;
                --n6;
                ++n4;
            }
        }
        while (nArray[n6 - 1] == 0) {
            --n6;
        }
        if (0 <= n4 && n4 < n2) {
            while (0 <= n4 && n5 < n6) {
                XEiJ.busWb(n3++, 48 + nArray[n5++]);
                --n4;
            }
            while (0 <= n4) {
                XEiJ.busWb(n3++, 48);
                --n4;
            }
            XEiJ.busWb(n3++, 46);
            while (n5 < n6) {
                XEiJ.busWb(n3++, 48 + nArray[n5++]);
            }
        } else if (-4 <= n4 && n4 < 0) {
            XEiJ.busWb(n3++, 48);
            XEiJ.busWb(n3++, 46);
            while (++n4 < 0) {
                XEiJ.busWb(n3++, 48);
            }
            while (n5 < n6) {
                XEiJ.busWb(n3++, 48 + nArray[n5++]);
            }
        } else {
            XEiJ.busWb(n3++, 48 + nArray[n5++]);
            XEiJ.busWb(n3++, 46);
            while (n5 < n6) {
                XEiJ.busWb(n3++, 48 + nArray[n5++]);
            }
            XEiJ.busWb(n3++, 69);
            if (0 <= n4) {
                XEiJ.busWb(n3++, 43);
            } else {
                XEiJ.busWb(n3++, 45);
                n4 = -n4;
            }
            n4 = XEiJ.FMT_BCD4[n4];
            XEiJ.busWb(n3++, 48 + (n4 >> 8));
            XEiJ.busWb(n3++, 48 + (n4 >> 4 & 0xF));
            XEiJ.busWb(n3++, 48 + (n4 & 0xF));
        }
        XEiJ.busWb(n3, 0);
        XEiJ.regRn[8] = n3;
    }

    public static void fpkFVAL() throws M68kException {
        int n = XEiJ.regRn[8];
        int n2 = XEiJ.busRbs(n++);
        while (n2 == 32 || n2 == 9) {
            n2 = XEiJ.busRbs(n++);
        }
        if (n2 == 38) {
            n2 = XEiJ.busRbs(n++) & 0xDF;
            XEiJ.regRn[8] = n;
            if (n2 == 66) {
                FEFunction.fpkSTOB();
                FEFunction.fpkLTOF();
            } else if (n2 == 79) {
                FEFunction.fpkSTOO();
                FEFunction.fpkLTOF();
            } else if (n2 == 72) {
                FEFunction.fpkSTOH();
                FEFunction.fpkLTOF();
            } else {
                XEiJ.regCCR = 9;
            }
        } else {
            FEFunction.fpkSTOF();
        }
    }

    public static void fpkFUSING() throws M68kException {
        FEFunction.fpkUSINGSub(Double.doubleToLongBits(Float.intBitsToFloat(XEiJ.regRn[0])));
    }

    public static void fpkSTOF() throws M68kException {
        int n = Float.floatToIntBits((float)FEFunction.fpkSTODSub());
        if (n == 2143289344) {
            n = Integer.MAX_VALUE;
        }
        XEiJ.regRn[0] = n;
    }

    public static void fpkFTOS() throws M68kException {
        FEFunction.fpkDTOSSub(Double.doubleToLongBits(Float.intBitsToFloat(XEiJ.regRn[0])));
    }

    public static void fpkFECVT() throws M68kException {
        FEFunction.fpkECVTSub(Double.doubleToLongBits(Float.intBitsToFloat(XEiJ.regRn[0])));
    }

    public static void fpkFFCVT() throws M68kException {
        FEFunction.fpkFCVTSub(Double.doubleToLongBits(Float.intBitsToFloat(XEiJ.regRn[0])));
    }

    public static void fpkFGCVT() throws M68kException {
        FEFunction.fpkGCVTSub(Double.doubleToLongBits(Float.intBitsToFloat(XEiJ.regRn[0])));
    }

    public static void fpkCLMUL() throws M68kException {
        int n = XEiJ.regRn[15];
        long l = (long)XEiJ.busRls(n) * (long)XEiJ.busRls(n + 4);
        int n2 = (int)l;
        XEiJ.busWl(n, n2);
        XEiJ.regCCR = (long)n2 == l ? 0 : 1;
    }

    public static void fpkCLDIV() throws M68kException {
        int n = XEiJ.regRn[15];
        int n2 = XEiJ.busRls(n + 4);
        if (n2 == 0) {
            XEiJ.regCCR = 1;
        } else {
            XEiJ.busWl(n, XEiJ.busRls(n) / n2);
            XEiJ.regCCR = 0;
        }
    }

    public static void fpkCLMOD() throws M68kException {
        int n = XEiJ.regRn[15];
        int n2 = XEiJ.busRls(n + 4);
        if (n2 == 0) {
            XEiJ.regCCR = 1;
        } else {
            XEiJ.busWl(n, XEiJ.busRls(n) % n2);
            XEiJ.regCCR = 0;
        }
    }

    public static void fpkCUMUL() throws M68kException {
        int n = XEiJ.regRn[15];
        long l = (0xFFFFFFFFL & (long)XEiJ.busRls(n)) * (0xFFFFFFFFL & (long)XEiJ.busRls(n + 4));
        int n2 = (int)l;
        XEiJ.busWl(n, n2);
        XEiJ.regCCR = (0xFFFFFFFFL & (long)n2) == l ? 0 : 1;
    }

    public static void fpkCUDIV() throws M68kException {
        int n = XEiJ.regRn[15];
        int n2 = XEiJ.busRls(n + 4);
        if (n2 == 0) {
            XEiJ.regCCR = 1;
        } else {
            XEiJ.busWl(n, (int)((0xFFFFFFFFL & (long)XEiJ.busRls(n)) / (0xFFFFFFFFL & (long)n2)));
            XEiJ.regCCR = 0;
        }
    }

    public static void fpkCUMOD() throws M68kException {
        int n = XEiJ.regRn[15];
        int n2 = XEiJ.busRls(n + 4);
        if (n2 == 0) {
            XEiJ.regCCR = 1;
        } else {
            XEiJ.busWl(n, (int)((0xFFFFFFFFL & (long)XEiJ.busRls(n)) % (0xFFFFFFFFL & (long)n2)));
            XEiJ.regCCR = 0;
        }
    }

    public static void fpkCLTOD() throws M68kException {
        int n = XEiJ.regRn[15];
        long l = Double.doubleToLongBits(XEiJ.busRls(n));
        XEiJ.busWl(n, (int)(l >>> 32));
        XEiJ.busWl(n + 4, (int)l);
    }

    public static void fpkCDTOL() throws M68kException {
        int n = XEiJ.regRn[15];
        double d = Double.longBitsToDouble((long)XEiJ.busRls(n) << 32 | 0xFFFFFFFFL & (long)XEiJ.busRls(n + 4));
        XEiJ.busWl(n, (int)d);
        XEiJ.regCCR = -2.147483649E9 < d && d < 2.147483648E9 ? 0 : 1;
    }

    public static void fpkCLTOF() throws M68kException {
        int n = XEiJ.regRn[15];
        XEiJ.busWl(n, Float.floatToIntBits(XEiJ.busRls(n)));
    }

    public static void fpkCFTOL() throws M68kException {
        int n = XEiJ.regRn[15];
        float f = Float.intBitsToFloat(XEiJ.busRls(n));
        XEiJ.busWl(n, (int)f);
        XEiJ.regCCR = -2.1474836E9f < f && f < 2.1474836E9f ? 0 : 1;
    }

    public static void fpkCFTOD() throws M68kException {
        int n = XEiJ.regRn[15];
        long l = Double.doubleToLongBits(Float.intBitsToFloat(XEiJ.busRls(n)));
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        XEiJ.busWl(n, (int)(l >>> 32));
        XEiJ.busWl(n + 4, (int)l);
    }

    public static void fpkCDTOF() throws M68kException {
        int n = XEiJ.regRn[15];
        double d = Double.longBitsToDouble((long)XEiJ.busRls(n) << 32 | 0xFFFFFFFFL & (long)XEiJ.busRls(n + 4));
        int n2 = Float.floatToIntBits((float)d);
        if (n2 == 2143289344) {
            n2 = Integer.MAX_VALUE;
        }
        XEiJ.busWl(n, n2);
        XEiJ.regCCR = Double.isNaN(d) || Double.isInfinite(d) || Math.abs(d) < 3.4028234663852886E38 + 0.5 * (double)Math.ulp(Float.MAX_VALUE) ? 0 : 1;
    }

    public static void fpkCDCMP() throws M68kException {
        double d;
        int n = XEiJ.regRn[15];
        double d2 = Double.longBitsToDouble((long)XEiJ.busRls(n) << 32 | 0xFFFFFFFFL & (long)XEiJ.busRls(n + 4));
        XEiJ.regCCR = d2 < (d = Double.longBitsToDouble((long)XEiJ.busRls(n + 8) << 32 | 0xFFFFFFFFL & (long)XEiJ.busRls(n + 12))) ? 9 : (d2 == d ? 4 : 0);
    }

    public static void fpkCDADD() throws M68kException {
        double d;
        int n = XEiJ.regRn[15];
        double d2 = Double.longBitsToDouble((long)XEiJ.busRls(n) << 32 | 0xFFFFFFFFL & (long)XEiJ.busRls(n + 4));
        double d3 = d2 + (d = Double.longBitsToDouble((long)XEiJ.busRls(n + 8) << 32 | 0xFFFFFFFFL & (long)XEiJ.busRls(n + 12)));
        long l = Double.doubleToLongBits(d3);
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        XEiJ.busWl(n, (int)(l >>> 32));
        XEiJ.busWl(n + 4, (int)l);
        XEiJ.regCCR = Double.isNaN(d2) || Double.isNaN(d) ? 0 : (Double.isNaN(d3) ? 1 : (Double.isInfinite(d2) || Double.isInfinite(d) ? 0 : (Double.isInfinite(d3) ? 3 : 0)));
    }

    public static void fpkCDSUB() throws M68kException {
        double d;
        int n = XEiJ.regRn[15];
        double d2 = Double.longBitsToDouble((long)XEiJ.busRls(n) << 32 | 0xFFFFFFFFL & (long)XEiJ.busRls(n + 4));
        double d3 = d2 - (d = Double.longBitsToDouble((long)XEiJ.busRls(n + 8) << 32 | 0xFFFFFFFFL & (long)XEiJ.busRls(n + 12)));
        long l = Double.doubleToLongBits(d3);
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        XEiJ.busWl(n, (int)(l >>> 32));
        XEiJ.busWl(n + 4, (int)l);
        XEiJ.regCCR = Double.isNaN(d2) || Double.isNaN(d) ? 0 : (Double.isNaN(d3) ? 1 : (Double.isInfinite(d2) || Double.isInfinite(d) ? 0 : (Double.isInfinite(d3) ? 3 : 0)));
    }

    public static void fpkCDMUL() throws M68kException {
        double d;
        int n = XEiJ.regRn[15];
        double d2 = Double.longBitsToDouble((long)XEiJ.busRls(n) << 32 | 0xFFFFFFFFL & (long)XEiJ.busRls(n + 4));
        double d3 = d2 * (d = Double.longBitsToDouble((long)XEiJ.busRls(n + 8) << 32 | 0xFFFFFFFFL & (long)XEiJ.busRls(n + 12)));
        long l = Double.doubleToLongBits(d3);
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        XEiJ.busWl(n, (int)(l >>> 32));
        XEiJ.busWl(n + 4, (int)l);
        XEiJ.regCCR = Double.isNaN(d2) || Double.isNaN(d) ? 0 : (Double.isNaN(d3) ? 1 : (Double.isInfinite(d2) || Double.isInfinite(d) ? 0 : (Double.isInfinite(d3) ? 3 : 0)));
    }

    public static void fpkCDDIV() throws M68kException {
        double d;
        int n = XEiJ.regRn[15];
        double d2 = Double.longBitsToDouble((long)XEiJ.busRls(n) << 32 | 0xFFFFFFFFL & (long)XEiJ.busRls(n + 4));
        double d3 = d2 / (d = Double.longBitsToDouble((long)XEiJ.busRls(n + 8) << 32 | 0xFFFFFFFFL & (long)XEiJ.busRls(n + 12)));
        long l = Double.doubleToLongBits(d3);
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        XEiJ.busWl(n, (int)(l >>> 32));
        XEiJ.busWl(n + 4, (int)l);
        XEiJ.regCCR = Double.isNaN(d2) || Double.isNaN(d) ? 0 : (Double.isNaN(d3) ? 1 : (Double.isInfinite(d2) || Double.isInfinite(d) ? 0 : (d == 0.0 ? 5 : (Double.isInfinite(d3) ? 3 : 0))));
    }

    public static void fpkCDMOD() throws M68kException {
        double d;
        int n = XEiJ.regRn[15];
        double d2 = Double.longBitsToDouble((long)XEiJ.busRls(n) << 32 | 0xFFFFFFFFL & (long)XEiJ.busRls(n + 4));
        double d3 = d2 % (d = Double.longBitsToDouble((long)XEiJ.busRls(n + 8) << 32 | 0xFFFFFFFFL & (long)XEiJ.busRls(n + 12)));
        long l = Double.doubleToLongBits(d3);
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        XEiJ.busWl(n, (int)(l >>> 32));
        XEiJ.busWl(n + 4, (int)l);
        XEiJ.regCCR = Double.isNaN(d2) || Double.isNaN(d) ? 0 : (d == 0.0 ? 5 : (Double.isNaN(d3) ? 1 : (Double.isInfinite(d2) || Double.isInfinite(d) ? 0 : (Double.isInfinite(d3) ? 3 : 0))));
    }

    public static void fpkCFCMP() throws M68kException {
        float f;
        int n = XEiJ.regRn[15];
        float f2 = Float.intBitsToFloat(XEiJ.busRls(n));
        XEiJ.regCCR = f2 < (f = Float.intBitsToFloat(XEiJ.busRls(n + 4))) ? 9 : (f2 == f ? 4 : 0);
    }

    public static void fpkCFADD() throws M68kException {
        float f;
        int n = XEiJ.regRn[15];
        float f2 = Float.intBitsToFloat(XEiJ.busRls(n));
        float f3 = f2 + (f = Float.intBitsToFloat(XEiJ.busRls(n + 4)));
        int n2 = Float.floatToIntBits(f3);
        if (n2 == 2143289344) {
            n2 = Integer.MAX_VALUE;
        }
        XEiJ.busWl(n, n2);
        XEiJ.regCCR = Float.isNaN(f2) || Float.isNaN(f) ? 0 : (Float.isNaN(f3) ? 1 : (Float.isInfinite(f2) || Float.isInfinite(f) ? 0 : (Float.isInfinite(f3) ? 3 : 0)));
    }

    public static void fpkCFSUB() throws M68kException {
        float f;
        int n = XEiJ.regRn[15];
        float f2 = Float.intBitsToFloat(XEiJ.busRls(n));
        float f3 = f2 - (f = Float.intBitsToFloat(XEiJ.busRls(n + 4)));
        int n2 = Float.floatToIntBits(f3);
        if (n2 == 2143289344) {
            n2 = Integer.MAX_VALUE;
        }
        XEiJ.busWl(n, n2);
        XEiJ.regCCR = Float.isNaN(f2) || Float.isNaN(f) ? 0 : (Float.isNaN(f3) ? 1 : (Float.isInfinite(f2) || Float.isInfinite(f) ? 0 : (Float.isInfinite(f3) ? 3 : 0)));
    }

    public static void fpkCFMUL() throws M68kException {
        float f;
        int n = XEiJ.regRn[15];
        float f2 = Float.intBitsToFloat(XEiJ.busRls(n));
        float f3 = f2 * (f = Float.intBitsToFloat(XEiJ.busRls(n + 4)));
        int n2 = Float.floatToIntBits(f3);
        if (n2 == 2143289344) {
            n2 = Integer.MAX_VALUE;
        }
        XEiJ.busWl(n, n2);
        XEiJ.regCCR = Float.isNaN(f2) || Float.isNaN(f) ? 0 : (Float.isNaN(f3) ? 1 : (Float.isInfinite(f2) || Float.isInfinite(f) ? 0 : (Float.isInfinite(f3) ? 3 : 0)));
    }

    public static void fpkCFDIV() throws M68kException {
        float f;
        int n = XEiJ.regRn[15];
        float f2 = Float.intBitsToFloat(XEiJ.busRls(n));
        float f3 = f2 / (f = Float.intBitsToFloat(XEiJ.busRls(n + 4)));
        int n2 = Float.floatToIntBits(f3);
        if (n2 == 2143289344) {
            n2 = Integer.MAX_VALUE;
        }
        XEiJ.busWl(n, n2);
        XEiJ.regCCR = Float.isNaN(f2) || Float.isNaN(f) ? 0 : (Float.isNaN(f3) ? 1 : (Float.isInfinite(f2) || Float.isInfinite(f) ? 0 : (f == 0.0f ? 5 : (Float.isInfinite(f3) ? 3 : 0))));
    }

    public static void fpkCFMOD() throws M68kException {
        float f;
        int n = XEiJ.regRn[15];
        float f2 = Float.intBitsToFloat(XEiJ.busRls(n));
        float f3 = f2 % (f = Float.intBitsToFloat(XEiJ.busRls(n + 4)));
        int n2 = Float.floatToIntBits(f3);
        if (n2 == 2143289344) {
            n2 = Integer.MAX_VALUE;
        }
        XEiJ.busWl(n, n2);
        XEiJ.regCCR = Float.isNaN(f2) || Float.isNaN(f) ? 0 : (f == 0.0f ? 5 : (Float.isNaN(f3) ? 1 : (Float.isInfinite(f2) || Float.isInfinite(f) ? 0 : (Float.isInfinite(f3) ? 3 : 0))));
    }

    public static void fpkCDTST() throws M68kException {
        int n = XEiJ.regRn[15];
        long l = (long)XEiJ.busRls(n) << 32 | 0xFFFFFFFFL & (long)XEiJ.busRls(n + 4);
        XEiJ.regCCR = l << 1 == 0L ? 4 : (0L <= l ? 0 : 8);
    }

    public static void fpkCFTST() throws M68kException {
        int n = XEiJ.busRls(XEiJ.regRn[15]);
        XEiJ.regCCR = n << 1 == 0 ? 4 : (0 <= n ? 0 : 8);
    }

    public static void fpkCDINC() throws M68kException {
        int n = XEiJ.regRn[15];
        double d = Double.longBitsToDouble((long)XEiJ.busRls(n) << 32 | 0xFFFFFFFFL & (long)XEiJ.busRls(n + 4));
        double d2 = d + 1.0;
        long l = Double.doubleToLongBits(d2);
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        XEiJ.busWl(n, (int)(l >>> 32));
        XEiJ.busWl(n + 4, (int)l);
        XEiJ.regCCR = Double.isInfinite(d2) && !Double.isInfinite(d) ? 3 : 0;
    }

    public static void fpkCFINC() throws M68kException {
        int n = XEiJ.regRn[15];
        float f = Float.intBitsToFloat(XEiJ.busRls(n));
        float f2 = f + 1.0f;
        int n2 = Float.floatToIntBits(f2);
        if (n2 == 2143289344) {
            n2 = Integer.MAX_VALUE;
        }
        XEiJ.busWl(n, n2);
        XEiJ.regCCR = Double.isInfinite(f2) && !Float.isInfinite(f) ? 3 : 0;
    }

    public static void fpkCDDEC() throws M68kException {
        int n = XEiJ.regRn[15];
        double d = Double.longBitsToDouble((long)XEiJ.busRls(n) << 32 | 0xFFFFFFFFL & (long)XEiJ.busRls(n + 4));
        double d2 = d - 1.0;
        long l = Double.doubleToLongBits(d2);
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        XEiJ.busWl(n, (int)(l >>> 32));
        XEiJ.busWl(n + 4, (int)l);
        XEiJ.regCCR = Double.isInfinite(d2) && !Double.isInfinite(d) ? 3 : 0;
    }

    public static void fpkCFDEC() throws M68kException {
        int n = XEiJ.regRn[15];
        float f = Float.intBitsToFloat(XEiJ.busRls(n));
        float f2 = f - 1.0f;
        int n2 = Float.floatToIntBits(f2);
        if (n2 == 2143289344) {
            n2 = Integer.MAX_VALUE;
        }
        XEiJ.busWl(n, n2);
        XEiJ.regCCR = Double.isInfinite(f2) && !Float.isInfinite(f) ? 3 : 0;
    }

    static {
        fpkRndTable = new int[55];
        fpkRndPointer = -1;
        fpkRandTable = new short[55];
        fpkRandPointer = -1;
        FPK_TEN_P16QR = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0, 1.0E16, 1.0E32, 1.0E48, 1.0E64, 1.0E80, 1.0E96, 1.0E112, 1.0E128, 1.0E144, 1.0E160, 1.0E176, 1.0E192, 1.0E208, 1.0E224, 1.0E240, 1.0, 1.0E256};
        FPK_TEN_M16QR = new double[]{1.0, 0.1, 0.01, 0.001, 1.0E-4, 1.0E-5, 1.0E-6, 1.0E-7, 1.0E-8, 1.0E-9, 1.0E-10, 1.0E-11, 1.0E-12, 1.0E-13, 1.0E-14, 1.0E-15, 1.0, 1.0E-16, 1.0E-32, 1.0E-48, 1.0E-64, 1.0E-80, 1.0E-96, 1.0E-112, 1.0E-128, 1.0E-144, 1.0E-160, 1.0E-176, 1.0E-192, 1.0E-208, 1.0E-224, 1.0E-240, 1.0, 1.0E-256};
    }
}

